/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.er;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int wj;
    private BitmapDescriptor PS;
    private LatLng PT;
    private float PU;
    private float PV;
    private LatLngBounds PW;
    private float PI;
    private float PP;
    private boolean PQ = true;
    private float PX = 0.0f;
    private float PY = 0.5f;
    private float PZ = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.wj = versionCode;
        this.PS = new BitmapDescriptor(b.a.G(wrappedImage));
        this.PT = location;
        this.PU = width;
        this.PV = height;
        this.PW = bounds;
        this.PI = bearing;
        this.PP = zIndex;
        this.PQ = visible;
        this.PX = transparency;
        this.PY = anchorU;
        this.PZ = anchorV;
    }

    public GroundOverlayOptions() {
        this.wj = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.hc()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder he() {
        return this.PS.gK().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.PS = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.PY = u2;
        this.PZ = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        er.a(this.PW == null, "Position has already been set using positionFromBounds");
        er.b(location != null, (Object)"Location must be specified");
        er.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        er.a(this.PW == null, "Position has already been set using positionFromBounds");
        er.b(location != null, (Object)"Location must be specified");
        er.b(width >= 0.0f, (Object)"Width must be non-negative");
        er.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.PT = latLng;
        this.PU = f2;
        this.PV = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        er.a(this.PT == null, "Position has already been set using position: " + this.PT);
        this.PW = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.PI = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.PP = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.PQ = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        er.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.PX = transparency;
        return this;
    }

    int getVersionCode() {
        return this.wj;
    }

    public BitmapDescriptor getImage() {
        return this.PS;
    }

    public LatLng getLocation() {
        return this.PT;
    }

    public float getWidth() {
        return this.PU;
    }

    public float getHeight() {
        return this.PV;
    }

    public LatLngBounds getBounds() {
        return this.PW;
    }

    public float getBearing() {
        return this.PI;
    }

    public float getZIndex() {
        return this.PP;
    }

    public float getTransparency() {
        return this.PX;
    }

    public float getAnchorU() {
        return this.PY;
    }

    public float getAnchorV() {
        return this.PZ;
    }

    public boolean isVisible() {
        return this.PQ;
    }
}

