/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.bo;
import com.google.android.gms.internal.cv;
import com.google.android.gms.internal.cw;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.de;
import com.google.android.gms.internal.df;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.l;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class dd
extends WebView
implements DownloadListener {
    private final de pY;
    private final a pZ;
    private final Object mg = new Object();
    private final l nP;
    private final db mG;
    private bo qa;
    private ab mF;
    private boolean qb;
    private boolean qc;

    public static dd a(Context context, ab ab2, boolean bl2, boolean bl3, l l2, db db2) {
        a a2 = new a(context);
        return new dd(a2, ab2, bl2, bl3, l2, db2);
    }

    private dd(a a2, ab ab2, boolean bl2, boolean bl3, l l2, db db2) {
        super((Context)a2);
        this.pZ = a2;
        this.mF = ab2;
        this.qb = bl2;
        this.nP = l2;
        this.mG = db2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        cv.a((Context)a2, db2.pU, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            cx.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            cw.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.pY = Build.VERSION.SDK_INT >= 11 ? new dg(this, bl3) : new de(this, bl3);
        this.setWebViewClient(this.pY);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new dh(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new df(this));
        }
        this.bf();
    }

    public void a(String string2, Map<String, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        if (map != null) {
            try {
                String string3 = cv.m(map).toString();
                stringBuilder.append(",");
                stringBuilder.append(string3);
            }
            catch (JSONException jSONException) {
                da.w("Could not convert AFMA event parameters to JSON.");
                return;
            }
        }
        stringBuilder.append(");");
        da.v("Dispatching AFMA event: " + stringBuilder);
        this.loadUrl(stringBuilder.toString());
    }

    public void aY() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.mG.pU);
        this.a("onhide", hashMap);
    }

    public void aZ() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.mG.pU);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public bo ba() {
        Object object = this.mg;
        synchronized (object) {
            return this.qa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ab Q() {
        Object object = this.mg;
        synchronized (object) {
            return this.mF;
        }
    }

    public de bb() {
        return this.pY;
    }

    public l bc() {
        return this.nP;
    }

    public db bd() {
        return this.mG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean be() {
        Object object = this.mg;
        synchronized (object) {
            return this.qb;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            da.s("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.nP != null) {
            this.nP.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.mg;
        synchronized (object) {
            if (this.isInEditMode() || this.qb) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.mF.widthPixels > n6 || this.mF.heightPixels > n7) {
                da.w("Not enough space to show ad. Needs " + this.mF.widthPixels + "x" + this.mF.heightPixels + " pixels, but only has " + n3 + "x" + n5 + " pixels.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.mF.widthPixels, this.mF.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, ab ab2) {
        Object object = this.mg;
        synchronized (object) {
            this.pZ.setBaseContext(context);
            this.qa = null;
            this.mF = ab2;
            this.qb = false;
            cv.b(this);
            this.loadUrl("about:blank");
            this.pY.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(bo bo2) {
        Object object = this.mg;
        synchronized (object) {
            this.qa = bo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ab ab2) {
        Object object = this.mg;
        synchronized (object) {
            this.mF = ab2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void n(boolean bl2) {
        Object object = this.mg;
        synchronized (object) {
            this.qb = bl2;
            this.bf();
        }
    }

    public void setContext(Context context) {
        this.pZ.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bf() {
        Object object = this.mg;
        synchronized (object) {
            if (this.qb || this.mF.lo) {
                if (Build.VERSION.SDK_INT < 14) {
                    da.s("Disabling hardware acceleration on an overlay.");
                    this.bg();
                } else {
                    da.s("Enabling hardware acceleration on an overlay.");
                    this.bh();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                da.s("Disabling hardware acceleration on an AdView.");
                this.bg();
            } else {
                da.s("Enabling hardware acceleration on an AdView.");
                this.bh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bg() {
        Object object = this.mg;
        synchronized (object) {
            if (!this.qc && Build.VERSION.SDK_INT >= 11) {
                cw.c((View)this);
            }
            this.qc = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bh() {
        Object object = this.mg;
        synchronized (object) {
            if (this.qc && Build.VERSION.SDK_INT >= 11) {
                cw.d((View)this);
            }
            this.qc = false;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity qd;
        private Context qe;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.qe = base.getApplicationContext();
            this.qd = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.qe);
        }

        public void startActivity(Intent intent) {
            if (this.qd != null) {
                this.qd.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.qe.startActivity(intent);
            }
        }
    }
}

