/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.b;
import com.google.android.gms.internal.ep;
import com.google.android.gms.internal.fm;
import com.google.android.gms.internal.fy;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
extends fy
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new a();
    private final int wj;
    private final String GU;
    private final String JS;
    private final long Jr;
    private final int JT;
    private final String FH;
    private final int Jv;
    private final Bundle JO;
    private final ArrayList<ParticipantEntity> Ju;
    private final int JU;

    public RoomEntity(Room room) {
        this.wj = 2;
        this.GU = room.getRoomId();
        this.JS = room.getCreatorId();
        this.Jr = room.getCreationTimestamp();
        this.JT = room.getStatus();
        this.FH = room.getDescription();
        this.Jv = room.getVariant();
        this.JO = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.Ju = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Ju.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.JU = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.wj = versionCode;
        this.GU = roomId;
        this.JS = creatorId;
        this.Jr = creationTimestamp;
        this.JT = roomStatus;
        this.FH = description;
        this.Jv = variant;
        this.JO = autoMatchCriteria;
        this.Ju = participants;
        this.JU = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.wj;
    }

    @Override
    public String getRoomId() {
        return this.GU;
    }

    @Override
    public String getCreatorId() {
        return this.JS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Jr;
    }

    @Override
    public int getStatus() {
        return this.JT;
    }

    @Override
    public String getDescription() {
        return this.FH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        fm.b(this.FH, dataOut);
    }

    @Override
    public int getVariant() {
        return this.Jv;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.JO;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Ju);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.JU;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return ep.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return ep.equal(room2.getRoomId(), room.getRoomId()) && ep.equal(room2.getCreatorId(), room.getCreatorId()) && ep.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && ep.equal(room2.getStatus(), room.getStatus()) && ep.equal(room2.getDescription(), room.getDescription()) && ep.equal(room2.getVariant(), room.getVariant()) && ep.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && ep.equal(room2.getParticipants(), room.getParticipants()) && ep.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return ep.e(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.dZ()) {
            b.a(this, dest, flags);
        } else {
            dest.writeString(this.GU);
            dest.writeString(this.JS);
            dest.writeLong(this.Jr);
            dest.writeInt(this.JT);
            dest.writeString(this.FH);
            dest.writeInt(this.Jv);
            dest.writeBundle(this.JO);
            int n2 = this.Ju.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Ju.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class a
    extends b {
        a() {
        }

        public RoomEntity aq(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.dY());
            if (bl2 || RoomEntity.ae(RoomEntity.class.getCanonicalName())) {
                return super.aq(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string3 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string, string2, l2, n3, string3, n4, bundle, arrayList, n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.aq(x0);
        }
    }
}

