/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int Fj;
    private int Fk;
    private final int Fl;
    private final List<DataBuffer<T>> Fm;
    private final LayoutInflater Fn;
    private boolean Fo = true;

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, List<DataBuffer<T>> objects) {
        this.mContext = context;
        this.Fj = this.Fk = resource;
        this.Fl = textViewResourceId;
        this.Fm = objects;
        this.Fn = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, List<DataBuffer<T>> objects) {
        this(context, resource, 0, objects);
    }

    public DataBufferAdapter(Context context, int resource) {
        this(context, resource, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, DataBuffer<T> ... buffers) {
        this(context, resource, textViewResourceId, Arrays.asList(buffers));
    }

    public DataBufferAdapter(Context context, int resource, DataBuffer<T> ... buffers) {
        this(context, resource, 0, Arrays.asList(buffers));
    }

    public void append(DataBuffer<T> buffer) {
        this.Fm.add(buffer);
        if (this.Fo) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.Fm) {
            dataBuffer.close();
        }
        this.Fm.clear();
        if (this.Fo) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.Fo = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.Fo = notifyOnChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n2 = 0;
        for (DataBuffer<T> dataBuffer : this.Fm) {
            n2 += dataBuffer.getCount();
        }
        return n2;
    }

    public T getItem(int position) throws CursorIndexOutOfBoundsException {
        int n2 = position;
        for (DataBuffer<T> dataBuffer : this.Fm) {
            int n3 = dataBuffer.getCount();
            if (n3 <= n2) {
                n2 -= n3;
                continue;
            }
            try {
                return dataBuffer.get(n2);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(position, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(position, this.getCount());
    }

    public long getItemId(int position) {
        return position;
    }

    private View a(int n2, View view, ViewGroup viewGroup, int n3) {
        TextView textView;
        View view2 = view == null ? this.Fn.inflate(n3, viewGroup, false) : view;
        try {
            textView = this.Fl == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.Fl);
        }
        catch (ClassCastException classCastException) {
            Log.e((String)"DataBufferAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t2 = this.getItem(n2);
        if (t2 instanceof CharSequence) {
            textView.setText((CharSequence)t2);
        } else {
            textView.setText((CharSequence)t2.toString());
        }
        return view2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.a(position, convertView, parent, this.Fj);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.a(position, convertView, parent, this.Fk);
    }

    public void setDropDownViewResource(int resource) {
        this.Fk = resource;
    }
}

