/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.es;
import com.google.android.gms.internal.et;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int yX;
    private View yY;
    private View.OnClickListener yZ = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.yX);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        er.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size " + buttonSize);
        er.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme " + colorScheme);
        this.mSize = buttonSize;
        this.yX = colorScheme;
        this.v(this.getContext());
    }

    private void v(Context context) {
        if (this.yY != null) {
            this.removeView(this.yY);
        }
        try {
            this.yY = es.d(context, this.mSize, this.yX);
        }
        catch (e.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.yY = SignInButton.c(context, this.mSize, this.yX);
        }
        this.addView(this.yY);
        this.yY.setEnabled(this.isEnabled());
        this.yY.setOnClickListener((View.OnClickListener)this);
    }

    private static Button c(Context context, int n2, int n3) {
        et et2 = new et(context);
        et2.a(context.getResources(), n2, n3);
        return et2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.yZ = listener;
        if (this.yY != null) {
            this.yY.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.yY.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.yZ != null && view == this.yY) {
            this.yZ.onClick((View)this);
        }
    }
}

