### ConstraintLayout Interview Questions

##### study recommendations

* [The official documentation](https://developer.android.com/reference/android/support/constraint/ConstraintLayout)
* [Pluralsight - Android Fundamentals - ConstraintLayout](https://app.pluralsight.com/library/courses/android-fundamentals-constraint-layout/table-of-contents)
* [Styling Android - ConstraintLayout tutorial series](https://blog.stylingandroid.com/?s=ConstraintLayout)
* [ConstraintLayout.com](https://constraintlayout.com/)
 
___

#### The Questionnaire
1. What is constrainlayout and When was it introduced to the community ?
2. How to add constraint layout to an existing project ?
3. What is constraintlayout resolver and what does it do ?
4. What are the advantages of using constraintlayout in design ?
5. How the constraintlayout arranges the views, compared to linear and relativelayout ?
6. What is the algorithm that constraintlayout uses internally ?
7. Explain the concept and application of `baseline` constraint.
8. Explain the concept and application of `center` constraint.
9. Explain the concept and application of `standard` constraint.
10. Explain the concept and application of `bias` in constraintlayout.
11. Explain the concept and application of `guideline` in constraintlayout.
12. Explain the concept and application of `barrier` in constraintlayout.
13. Explain the concept and application of `group` in constraintlayout.
14. Explain the concept and application of `chaining` in constraintlayout.
15. Explain `chaining modes` and their differences.
16. Explain the concept and application of `match_constraint` in constraintlayout.
17. Explain the concept and application of `ratio` in constraintlayout.
18. Explain the concept and application of `circular positioning` in constraintlayout.
19. What are some pitfalls of using `WRAP_CONTENT` when using with constraintlayout ?
20. What are some pitfalls of using `Convert to ConstraintLayout tool` in Android Studio ?
21. What is the `optimization level`?
22. What are different optimization levels in constraintlayout ?
23. What strange behaviors can happen when using Packt/Expand buttons in the Layout Editor, on a constraintlayout ?
24. Implement a circular clock by using ConstraintLayout.
25. Which of the following width/height attributes is more costy, when using with ConstraintLayout ?
	* exact dimensions
	* match_constraint
26. Convert an existing complex layout to ConstraintLayout.
27. Explain about the double-measurement issue in LineatLayout and RelativeLayout.
28. What is the purpose of `ConstraintChangeListener` ?
29. What is the purpose of `ConstraintSet` ?

