# Algorithms and Data Structures

This repository contains my implementations of some important Data Structures and Algorithms in Java (see the list below). The idea here was to keep the code for the algorithms as simple as possible, so I didn't implement it with OO design principles in mind (don't try this at home, folks!). Each implementation has its unit tests under `src/test/java/com/jorgeacetozi/algorithms`. Have fun!

- [Binary Search](src/main/java/com/jorgeacetozi/algorithms/binarySearch/GenericBinarySearch.java)
- [Binary Search Tree](src/main/java/com/jorgeacetozi/algorithms/binarySearchTree/BinarySearchTree.java)
- [Breadth First Search](src/main/java/com/jorgeacetozi/algorithms/breadthFirstSearch/BreadthFirstSearch.java)
- Cache: [LRU](src/main/java/com/jorgeacetozi/algorithms/cache/leastRecentlyUsed/LRUCache.java) and [LFU](src/main/java/com/jorgeacetozi/algorithms/cache/leastFrequentlyUsed/LFUCache.java)
- [Connectivity in Graphs](src/main/java/com/jorgeacetozi/algorithms/connectivity/OptimizedConnectivity.java)
- [Cycle Detection in Graphs](src/main/java/com/jorgeacetozi/algorithms/cycleDetection/CycleDetection.java)
- [Depth First Search](src/main/java/com/jorgeacetozi/algorithms/depthFirstSearch/DepthFirstSearch.java)
- [Dijkstra's Algorithm](src/main/java/com/jorgeacetozi/algorithms/dijkstra/Dijkstra.java) (Shortest Path from a Single Source)
- [Doubly Linked List](src/main/java/com/jorgeacetozi/algorithms/doublyLinkedList/DoublyLinkedList.java)
- Hash: [Chaining](src/main/java/com/jorgeacetozi/algorithms/hash/chaining/HashTableChaining.java) and [Linear Probing](src/main/java/com/jorgeacetozi/algorithms/hash/linearProbing/HashTableLinearProbing.java)
- [Heap](src/main/java/com/jorgeacetozi/algorithms/heap/GenericMinHeap.java) and [Indexed Heap](src/main/java/com/jorgeacetozi/algorithms/cache/leastFrequentlyUsed/minIndexedHeap/MinIndexedHeap.java)
- [Prim's Algorithm](src/main/java/com/jorgeacetozi/algorithms/prim/Prim.java) (Minimum Spanning Tree)
- Queue: [LinkedList](src/main/java/com/jorgeacetozi/algorithms/queue/singlyLinkedListWithTail/SinglyLinkedListWithTail.java) and [Circular Array](src/main/java/com/jorgeacetozi/algorithms/queue/staticCircularArray/StaticCircularArray.java) implementations
- [Quickselect](src/main/java/com/jorgeacetozi/algorithms/quickselect/Quickselect.java)
- [Singly Linked List](src/main/java/com/jorgeacetozi/algorithms/singlyLinkedList/SinglyLinkedListWithTail.java)
- Sorting: [Heapsort](src/main/java/com/jorgeacetozi/algorithms/sorting/heapsort/Heapsort.java) and [Quicksort](src/main/java/com/jorgeacetozi/algorithms/sorting/quicksort/GenericQuicksort.java)
- Stack: [Static Array](src/main/java/com/jorgeacetozi/algorithms/stack/staticArray/StaticArrayStack.java), [Singly Linked List](src/main/java/com/jorgeacetozi/algorithms/stack/singlyLinkedList/SinglyLinkedList.java), and [Dynamic Array](src/main/java/com/jorgeacetozi/algorithms/stack/dynamicArray/DynamicArrayStack.java) implementations
- [Ternary Search Tree](src/main/java/com/jorgeacetozi/algorithms/ternarySearchTree/TernarySearchTree.java)
- [Topological Sort](src/main/java/com/jorgeacetozi/algorithms/topologicalSort/TopologicalSort.java)
