/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.logging.Level;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import sf.util.DatabaseUtility;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;

public final class SchemaCrawlerUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerUtility.class.getName());

    private static SchemaRetrievalOptionsBuilder buildSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.lookupDatabaseConnector(connection);
        LOGGER.log(Level.INFO, "Using database plugin for " + dbConnector.getDatabaseServerType());
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
        return schemaRetrievalOptionsBuilder;
    }

    private static void checkConnection(Connection connection) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkConnection(connection);
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException("Bad database connection", e);
        }
    }

    private static void checkResultSet(ResultSet resultSet) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkResultSet(resultSet);
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException("Bad result-set", e);
        }
    }

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, ObjectToString.toString(schemaCrawlerOptions));
        }
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(connection);
        SchemaCrawler schemaCrawler = new SchemaCrawler(connection, schemaRetrievalOptions, schemaCrawlerOptions);
        Catalog catalog = schemaCrawler.crawl();
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkResultSet(resultSet);
        ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
        ResultsColumns resultsColumns = resultSetCrawler.crawl();
        return resultsColumns;
    }

    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaCrawlerUtility.buildSchemaRetrievalOptions(connection);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        return schemaRetrievalOptions;
    }

    private SchemaCrawlerUtility() {
    }
}

