/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InclusionRuleWithRegularExpression;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.NamedObjectSort;
import schemacrawler.utility.Query;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class QueryUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(QueryUtility.class.getName());

    public static ResultSet executeAgainstSchema(Query query, Statement statement, InclusionRule schemaInclusionRule) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, schemaInclusionRule);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static ResultSet executeAgainstTable(Query query, Statement statement, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        String sql = QueryUtility.getQuery(query, table, isAlphabeticalSortForTableColumns, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static long executeForLong(Query query, Connection connection, Table table, Identifiers identifiers) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForLong(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection, Table table, Identifiers identifiers) throws SchemaCrawlerException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    private static String getColumnsListAsString(List<Column> columns, boolean omitLargeObjectColumns, Identifiers identifiers) {
        ArrayList<String> columnsList = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && (javaSqlTypeGroup == JavaSqlTypeGroup.large_object || javaSqlTypeGroup == JavaSqlTypeGroup.object)) continue;
            columnsList.add(identifiers.quoteName(column.getName()));
        }
        return String.join((CharSequence)", ", columnsList);
    }

    private static String getQuery(Query query) {
        return TemplatingUtility.expandTemplate(query.getQuery());
    }

    private static String getQuery(Query query, InclusionRule schemaInclusionRule) {
        String schemaInclusionPattern;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schemas", ".*");
        if (schemaInclusionRule != null && schemaInclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)schemaInclusionRule).getInclusionPattern().pattern())) {
            properties.put("schemas", schemaInclusionPattern);
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, properties);
        sql = TemplatingUtility.expandTemplate(sql);
        return sql;
    }

    private static String getQuery(Query query, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort(isAlphabeticalSortForTableColumns);
            List<Column> columns = table.getColumns();
            columns.sort(columnsSort);
            Schema schema = table.getSchema();
            if (schema != null) {
                String schemaName = identifiers.quoteFullName(schema);
                tableProperties.put("schema", schemaName);
            }
            tableProperties.put("table", identifiers.quoteFullName(table));
            tableProperties.put("tablename", table.getName());
            tableProperties.put("columns", QueryUtility.getColumnsListAsString(columns, false, identifiers));
            tableProperties.put("orderbycolumns", QueryUtility.getColumnsListAsString(columns, true, identifiers));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, tableProperties);
        sql = TemplatingUtility.expandTemplate(sql);
        return sql;
    }

    private QueryUtility() {
    }
}

