/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.text.schema.BaseSchemaTextOptionsBuilder;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class GraphOptionsBuilder
extends BaseSchemaTextOptionsBuilder<GraphOptionsBuilder, GraphOptions> {
    protected static final String SCHEMACRAWLER_GRAPH_PREFIX = "schemacrawler.graph.";
    private static final String GRAPH_SHOW_PRIMARY_KEY_CARDINALITY = "schemacrawler.graph.show.primarykey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_CARDINALITY = "schemacrawler.graph.show.foreignkey.cardinality";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final String GRAPH_GRAPHVIZ_ATTRIBUTES = "schemacrawler.graph.graphviz";
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphOptions.class.getName());
    protected List<String> graphvizOpts = new ArrayList<String>();
    protected Map<String, String> graphvizAttributes = GraphOptionsBuilder.makeDefaultGraphvizAttributes();
    protected boolean isShowForeignKeyCardinality = true;
    protected boolean isShowPrimaryKeyCardinality = true;

    public static GraphOptionsBuilder builder() {
        return new GraphOptionsBuilder();
    }

    public static GraphOptionsBuilder builder(GraphOptions options) {
        return new GraphOptionsBuilder().fromOptions(options);
    }

    private static Map<String, String> makeDefaultGraphvizAttributes() {
        HashMap<String, String> graphvizAttributes = new HashMap<String, String>();
        String GRAPH = "graph.";
        graphvizAttributes.put("graph.rankdir", "RL");
        graphvizAttributes.put("graph.labeljust", "r");
        graphvizAttributes.put("graph.fontname", "Helvetica");
        String NODE = "node.";
        graphvizAttributes.put("node.shape", "none");
        graphvizAttributes.put("node.fontname", "Helvetica");
        String EDGE = "edge.";
        graphvizAttributes.put("edge.fontname", "Helvetica");
        return graphvizAttributes;
    }

    public static GraphOptions newGraphOptions(Config config) {
        return new GraphOptionsBuilder().fromConfig(config).toOptions();
    }

    public static GraphOptions newGraphOptions() {
        return new GraphOptionsBuilder().toOptions();
    }

    private GraphOptionsBuilder() {
    }

    @Override
    public GraphOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        super.fromConfig(config);
        this.isShowPrimaryKeyCardinality = config.getBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, true);
        this.isShowForeignKeyCardinality = config.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, true);
        this.graphvizOpts = this.listGraphvizOpts(this.readGraphvizOpts(config));
        Map<String, String> graphvizAttributes = this.readGraphvizAttributes(config);
        if (graphvizAttributes != null) {
            this.graphvizAttributes = graphvizAttributes;
        }
        return this;
    }

    @Override
    public GraphOptionsBuilder fromOptions(GraphOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions(options);
        this.isShowPrimaryKeyCardinality = options.isShowPrimaryKeyCardinality();
        this.isShowForeignKeyCardinality = options.isShowForeignKeyCardinality();
        this.graphvizOpts = options.getGraphvizOpts();
        this.graphvizAttributes = options.getGraphvizAttributes();
        return this;
    }

    public GraphOptionsBuilder showForeignKeyCardinality() {
        return this.showForeignKeyCardinality(true);
    }

    public GraphOptionsBuilder showForeignKeyCardinality(boolean value) {
        this.isShowForeignKeyCardinality = value;
        return this;
    }

    public GraphOptionsBuilder showPrimaryKeyCardinality() {
        return this.showPrimaryKeyCardinality(true);
    }

    public GraphOptionsBuilder showPrimaryKeyCardinality(boolean value) {
        this.isShowPrimaryKeyCardinality = value;
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.setBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, this.isShowPrimaryKeyCardinality);
        config.setBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, this.isShowForeignKeyCardinality);
        config.setStringValue(GRAPH_GRAPHVIZ_OPTS, Utility.join(this.graphvizOpts, " "));
        this.graphvizAttributesToConfig(this.graphvizAttributes, config);
        return config;
    }

    @Override
    public GraphOptions toOptions() {
        return new GraphOptions(this);
    }

    public GraphOptionsBuilder withGraphvizAttributes(Map<String, String> graphvizAttributes) {
        this.graphvizAttributes = graphvizAttributes == null ? GraphOptionsBuilder.makeDefaultGraphvizAttributes() : graphvizAttributes;
        return this;
    }

    public GraphOptionsBuilder withGraphvizOpts(List<String> graphvizOpts) {
        this.graphvizOpts = graphvizOpts == null ? new ArrayList<String>() : graphvizOpts;
        return this;
    }

    private void graphvizAttributesToConfig(Map<String, String> graphvizAttributes, Config config) {
        for (Map.Entry<String, String> graphvizAttribute : graphvizAttributes.entrySet()) {
            String fullKey = String.format("%s.%s", GRAPH_GRAPHVIZ_ATTRIBUTES, graphvizAttribute.getKey());
            String value = graphvizAttribute.getValue();
            config.put(fullKey, value);
        }
    }

    private List<String> listGraphvizOpts(String graphVizOptions) {
        List<String> graphVizOptionsList = Arrays.asList(graphVizOptions.split("\\s+"));
        return graphVizOptionsList;
    }

    private Map<String, String> readGraphvizAttributes(Config config) {
        if (config == null) {
            return null;
        }
        HashMap<String, String> graphvizAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : config.entrySet()) {
            String fullKey = configEntry.getKey();
            if (fullKey == null || !fullKey.startsWith(GRAPH_GRAPHVIZ_ATTRIBUTES)) continue;
            String key = fullKey.substring(GRAPH_GRAPHVIZ_ATTRIBUTES.length() + 1);
            String value = configEntry.getValue();
            graphvizAttributes.put(key, value);
        }
        if (graphvizAttributes.isEmpty()) {
            return null;
        }
        return graphvizAttributes;
    }

    private String readGraphvizOpts(Config config) {
        String scGraphvizOptsCfg = config.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank(scGraphvizOptsCfg)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from config <%s>", scGraphvizOptsCfg));
            return scGraphvizOptsCfg;
        }
        String scGraphvizOptsProp = System.getProperty(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphvizOptsProp)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS system property <%s>", scGraphvizOptsProp));
            return scGraphvizOptsProp;
        }
        String scGraphvizOptsEnv = System.getenv(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank(scGraphvizOptsEnv)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS environmental variable <%s>", scGraphvizOptsEnv));
            return scGraphvizOptsEnv;
        }
        return "";
    }
}

