/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.FunctionParameterRetriever;
import schemacrawler.crawl.IndexRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.ProcedureParameterRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineExtRetriever;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.SequenceRetriever;
import schemacrawler.crawl.SynonymRetriever;
import schemacrawler.crawl.TableColumnRetriever;
import schemacrawler.crawl.TableConstraintRetriever;
import schemacrawler.crawl.TableExtRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StopWatch;
import sf.util.StringFormat;

public final class SchemaCrawler {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawler.class.getName());
    private final Connection connection;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final SchemaRetrievalOptions schemaRetrievalOptions;

    private static void crawlColumnDataTypes(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            LOGGER.log(Level.INFO, "Crawling column data types");
            StopWatch stopWatch = new StopWatch("crawlColumnDataTypes");
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, catalog, options);
            stopWatch.time("retrieveSystemColumnDataTypes", () -> {
                if (infoLevel.isRetrieveColumnDataTypes()) {
                    LOGGER.log(Level.INFO, "Retrieving system column data types");
                    retriever.retrieveSystemColumnDataTypes();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving system column data types, since this was not requested");
                }
                return null;
            });
            stopWatch.time("retrieveUserDefinedColumnDataTypes", () -> {
                if (infoLevel.isRetrieveUserDefinedColumnDataTypes()) {
                    LOGGER.log(Level.INFO, "Retrieving user column data types");
                    for (Schema schema : retriever.getAllSchemas()) {
                        retriever.retrieveUserDefinedColumnDataTypes(schema);
                    }
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving user column data types, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving column data type information", e);
        }
    }

    private static void crawlDatabaseInfo(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            boolean retrieveDatabaseInfo = infoLevel.isRetrieveDatabaseInfo();
            if (!retrieveDatabaseInfo) {
                LOGGER.log(Level.INFO, "Not retrieving database information, since this was not requested");
                return;
            }
            StopWatch stopWatch = new StopWatch("crawlDatabaseInfo");
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, catalog, options);
            LOGGER.log(Level.INFO, "Retrieving database information");
            stopWatch.time("retrieveDatabaseInfo", () -> {
                retriever.retrieveDatabaseInfo();
                return null;
            });
            stopWatch.time("retrieveAdditionalDatabaseInfo", () -> {
                if (infoLevel.isRetrieveAdditionalDatabaseInfo()) {
                    retriever.retrieveAdditionalDatabaseInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving additional database information, since this was not requested");
                }
                return null;
            });
            stopWatch.time("retrieveServerInfo", () -> {
                if (infoLevel.isRetrieveServerInfo()) {
                    retriever.retrieveServerInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving JDBC driver information");
            stopWatch.time("retrieveJdbcDriverInfo", () -> {
                retriever.retrieveJdbcDriverInfo();
                return null;
            });
            stopWatch.time("retrieveAdditionalJdbcDriverInfo", () -> {
                if (infoLevel.isRetrieveAdditionalJdbcDriverInfo()) {
                    retriever.retrieveAdditionalJdbcDriverInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving additional JDBC driver information, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving SchemaCrawler crawl information");
            stopWatch.time("retrieveCrawlInfo", () -> {
                retriever.retrieveCrawlInfo();
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private static void crawlRoutines(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveRoutines = infoLevel.isRetrieveRoutines();
        if (!retrieveRoutines) {
            LOGGER.log(Level.INFO, "Not retrieving routines, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlRoutines");
        LOGGER.log(Level.INFO, "Crawling routines");
        try {
            RoutineRetriever retriever = new RoutineRetriever(retrieverConnection, catalog, options);
            RoutineExtRetriever retrieverExtra = new RoutineExtRetriever(retrieverConnection, catalog, options);
            ProcedureParameterRetriever procedureParameterRetriever = new ProcedureParameterRetriever(retrieverConnection, catalog, options);
            FunctionParameterRetriever functionParameterRetriever = new FunctionParameterRetriever(retrieverConnection, catalog, options);
            Collection<RoutineType> routineTypes = options.getRoutineTypes();
            stopWatch.time("retrieveRoutines", () -> {
                NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
                if (routineTypes.contains((Object)RoutineType.procedure)) {
                    LOGGER.log(Level.INFO, "Retrieving procedure names");
                    retriever.retrieveProcedures(schemas, options.getRoutineInclusionRule());
                }
                if (routineTypes.contains((Object)RoutineType.function)) {
                    LOGGER.log(Level.INFO, "Retrieving function names");
                    retriever.retrieveFunctions(schemas, options.getRoutineInclusionRule());
                }
                return null;
            });
            NamedObjectList<MutableRoutine> allRoutines = catalog.getAllRoutines();
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d routines", allRoutines.size()));
            if (allRoutines.isEmpty()) {
                return;
            }
            stopWatch.time("retrieveRoutineParameters", () -> {
                LOGGER.log(Level.INFO, "Retrieving routine columns");
                if (infoLevel.isRetrieveRoutineParameters()) {
                    if (routineTypes.contains((Object)RoutineType.procedure)) {
                        procedureParameterRetriever.retrieveProcedureParameters(allRoutines, options.getRoutineParameterInclusionRule());
                    }
                    if (routineTypes.contains((Object)RoutineType.function)) {
                        functionParameterRetriever.retrieveFunctionParameters(allRoutines, options.getRoutineParameterInclusionRule());
                    }
                }
                return null;
            });
            stopWatch.time("filterAndSortRoutines", () -> {
                catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(options));
                return null;
            });
            stopWatch.time("retrieveRoutineInformation", () -> {
                if (infoLevel.isRetrieveRoutineInformation()) {
                    retrieverExtra.retrieveRoutineInformation();
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving routine information", e);
        }
    }

    private static void crawlSchemas(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        StopWatch stopWatch = new StopWatch("crawlSchemas");
        LOGGER.log(Level.INFO, "Crawling schemas");
        try {
            SchemaRetriever retriever = new SchemaRetriever(retrieverConnection, catalog, options);
            stopWatch.time("retrieveSchemas", () -> {
                retriever.retrieveSchemas(options.getSchemaInclusionRule());
                return null;
            });
            stopWatch.time("filterAndSortSchemas", () -> {
                catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
            NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
            if (schemas.isEmpty()) {
                throw new SchemaCrawlerException("No matching schemas found");
            }
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d schemas", schemas.size()));
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving schema information", e);
        }
    }

    private static void crawlSequences(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveSequences = infoLevel.isRetrieveSequenceInformation();
        if (!retrieveSequences) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlSequences");
        LOGGER.log(Level.INFO, "Crawling sequences");
        try {
            SequenceRetriever retrieverExtra = new SequenceRetriever(retrieverConnection, catalog, options);
            stopWatch.time("retrieveSequenceInformation", () -> {
                retrieverExtra.retrieveSequenceInformation(options.getSequenceInclusionRule());
                return null;
            });
            stopWatch.time("filterAndSortSequences", () -> {
                catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving sequence information", e);
        }
    }

    private static void crawlSynonyms(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveSynonyms = infoLevel.isRetrieveSynonymInformation();
        if (!retrieveSynonyms) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlSynonyms");
        LOGGER.log(Level.INFO, "Crawling synonyms");
        try {
            SynonymRetriever retrieverExtra = new SynonymRetriever(retrieverConnection, catalog, options);
            stopWatch.time("retrieveSynonymInformation", () -> {
                retrieverExtra.retrieveSynonymInformation(options.getSynonymInclusionRule());
                return null;
            });
            stopWatch.time("filterAndSortSynonms", () -> {
                catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving synonym information", e);
        }
    }

    private static void crawlTables(MutableCatalog catalog, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveTables = infoLevel.isRetrieveTables();
        if (!retrieveTables) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlTables");
        LOGGER.log(Level.INFO, "Crawling tables");
        try {
            TableRetriever retriever = new TableRetriever(retrieverConnection, catalog, options);
            TableColumnRetriever columnRetriever = new TableColumnRetriever(retrieverConnection, catalog, options);
            IndexRetriever indexRetriever = new IndexRetriever(retrieverConnection, catalog, options);
            ForeignKeyRetriever fkRetriever = new ForeignKeyRetriever(retrieverConnection, catalog, options);
            TableConstraintRetriever constraintRetriever = new TableConstraintRetriever(retrieverConnection, catalog, options);
            TableExtRetriever retrieverExtra = new TableExtRetriever(retrieverConnection, catalog, options);
            stopWatch.time("retrieveTables", () -> {
                LOGGER.log(Level.INFO, "Retrieving table names");
                NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
                retriever.retrieveTables(schemas, options.getTableNamePattern(), options.getTableTypes(), options.getTableInclusionRule());
                return null;
            });
            NamedObjectList<MutableTable> allTables = catalog.getAllTables();
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d tables", allTables.size()));
            if (allTables.isEmpty()) {
                return;
            }
            stopWatch.time("retrieveColumns", () -> {
                LOGGER.log(Level.INFO, "Retrieving table columns");
                if (infoLevel.isRetrieveTableColumns()) {
                    columnRetriever.retrieveTableColumns(allTables, options.getColumnInclusionRule());
                }
                return null;
            });
            stopWatch.time("retrieveForeignKeys", () -> {
                LOGGER.log(Level.INFO, "Retrieving foreign keys");
                if (infoLevel.isRetrieveForeignKeys()) {
                    if (infoLevel.isRetrieveTableColumns()) {
                        fkRetriever.retrieveForeignKeys(allTables);
                        if (infoLevel.isRetrieveForeignKeyDefinitions()) {
                            fkRetriever.retrieveForeignKeyDefinitions(allTables);
                        }
                    }
                } else {
                    LOGGER.log(Level.WARNING, "Foreign-keys are not being retrieved, so tables cannot be sorted using the natural sort order");
                }
                return null;
            });
            stopWatch.time("filterAndSortTables", () -> {
                catalog.reduce(Table.class, ReducerFactory.getTableReducer(options));
                TablesGraph tablesGraph = new TablesGraph(allTables);
                tablesGraph.setTablesSortIndexes();
                return null;
            });
            stopWatch.time("retrieveIndexes", () -> {
                LOGGER.log(Level.INFO, "Retrieving primary keys and indexes");
                if (infoLevel.isRetrieveTableColumns()) {
                    if (infoLevel.isRetrieveIndexes()) {
                        indexRetriever.retrieveIndexes(allTables);
                    }
                    indexRetriever.retrievePrimaryKeys(allTables);
                    if (infoLevel.isRetrievePrimaryKeyDefinitions()) {
                        retrieverExtra.retrievePrimaryKeyDefinitions(allTables);
                    }
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving additional table information");
            stopWatch.time("retrieveTableConstraintInformation", () -> {
                if (infoLevel.isRetrieveTableConstraintInformation()) {
                    constraintRetriever.retrieveTableConstraintInformation();
                }
                return null;
            });
            stopWatch.time("isRetrieveTableConstraintDefinitions", () -> {
                if (infoLevel.isRetrieveTableConstraintDefinitions()) {
                    constraintRetriever.retrieveTableConstraintDefinitions();
                }
                return null;
            });
            stopWatch.time("retrieveTriggerInformation", () -> {
                if (infoLevel.isRetrieveTriggerInformation()) {
                    retrieverExtra.retrieveTriggerInformation();
                }
                return null;
            });
            stopWatch.time("retrieveViewInformation", () -> {
                if (infoLevel.isRetrieveViewInformation()) {
                    retrieverExtra.retrieveViewInformation();
                }
                return null;
            });
            stopWatch.time("retrieveTableDefinitions", () -> {
                if (infoLevel.isRetrieveTableDefinitionsInformation()) {
                    retrieverExtra.retrieveTableDefinitions();
                }
                return null;
            });
            stopWatch.time("retrieveIndexInformation", () -> {
                if (infoLevel.isRetrieveIndexInformation()) {
                    retrieverExtra.retrieveIndexInformation();
                    if (infoLevel.isRetrieveIndexColumnInformation()) {
                        retrieverExtra.retrieveIndexColumnInformation();
                    }
                }
                return null;
            });
            stopWatch.time("retrieveAdditionalTableAttributes", () -> {
                if (infoLevel.isRetrieveAdditionalTableAttributes()) {
                    retrieverExtra.retrieveAdditionalTableAttributes();
                }
                return null;
            });
            stopWatch.time("retrieveTablePrivileges", () -> {
                if (infoLevel.isRetrieveTablePrivileges()) {
                    retrieverExtra.retrieveTablePrivileges();
                }
                return null;
            });
            stopWatch.time("retrieveAdditionalColumnAttributes", () -> {
                if (infoLevel.isRetrieveAdditionalColumnAttributes()) {
                    retrieverExtra.retrieveAdditionalColumnAttributes();
                }
                return null;
            });
            stopWatch.time("retrieveTableColumnPrivileges", () -> {
                if (infoLevel.isRetrieveTableColumnPrivileges()) {
                    retrieverExtra.retrieveTableColumnPrivileges();
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving table information", e);
        }
    }

    public SchemaCrawler(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions) {
        this.connection = Objects.requireNonNull(connection, "No connection specified");
        this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database-specific schema retrieval overrides provided");
        this.schemaCrawlerOptions = Objects.requireNonNull(schemaCrawlerOptions, "No SchemaCrawler options provided");
    }

    public Catalog crawl() throws SchemaCrawlerException {
        MutableCatalog catalog = new MutableCatalog("catalog");
        try {
            RetrieverConnection retrieverConnection = new RetrieverConnection(this.connection, this.schemaRetrievalOptions);
            SchemaCrawler.crawlDatabaseInfo(catalog, retrieverConnection, this.schemaCrawlerOptions);
            LOGGER.log(Level.INFO, String.format("%n%s", catalog.getCrawlInfo()));
            SchemaCrawler.crawlSchemas(catalog, retrieverConnection, this.schemaCrawlerOptions);
            SchemaCrawler.crawlColumnDataTypes(catalog, retrieverConnection, this.schemaCrawlerOptions);
            SchemaCrawler.crawlTables(catalog, retrieverConnection, this.schemaCrawlerOptions);
            SchemaCrawler.crawlRoutines(catalog, retrieverConnection, this.schemaCrawlerOptions);
            SchemaCrawler.crawlSynonyms(catalog, retrieverConnection, this.schemaCrawlerOptions);
            SchemaCrawler.crawlSequences(catalog, retrieverConnection, this.schemaCrawlerOptions);
            return catalog;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Database access exception", e);
        }
    }
}

