/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.utility.CompareUtility;
import sf.util.Utility;

abstract class MutableRoutine
extends AbstractDatabaseObject
implements Routine {
    private static final long serialVersionUID = 3906925686089134130L;
    private final StringBuilder definition;
    private RoutineBodyType routineBodyType = RoutineBodyType.unknown;
    private String specificName;

    MutableRoutine(Schema schema, String name) {
        super(schema, name);
        this.definition = new StringBuilder();
    }

    @Override
    public int compareTo(NamedObject obj) {
        int comparison = super.compareTo(obj);
        if (obj instanceof Routine) {
            Routine other = (Routine)obj;
            if (comparison == 0) {
                List thisParameters = this.getParameters();
                List otherParameters = other.getParameters();
                comparison = CompareUtility.compareLists(thisParameters, otherParameters);
            }
            if (comparison == 0) {
                comparison = this.getSpecificName().compareTo(other.getSpecificName());
            }
        }
        return comparison;
    }

    @Override
    public final List<String> toUniqueLookupKey() {
        ArrayList<String> lookupKey = new ArrayList<String>(super.toUniqueLookupKey());
        lookupKey.add(this.specificName);
        return lookupKey;
    }

    @Override
    public final String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public final boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public final RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    final void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    @Override
    public RoutineType getRoutineType() {
        return null;
    }

    @Override
    public final String getSpecificName() {
        if (Utility.isBlank(this.specificName)) {
            return this.getName();
        }
        return this.specificName;
    }

    final void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    @Override
    public final RoutineType getType() {
        return this.getRoutineType();
    }

    final void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }
}

