/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

public abstract class BaseColumnReference
implements ColumnReference,
Comparable<ColumnReference> {
    private static final long serialVersionUID = -4411771492159843382L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;

    protected BaseColumnReference(Column primaryKeyColumn, Column foreignKeyColumn) {
        this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "No primary key column provided");
        this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "No foreign key column provided");
    }

    @Override
    public int compareTo(ColumnReference columnRef) {
        if (columnRef == null) {
            return -1;
        }
        int compare = 0;
        if (compare == 0) {
            compare = this.primaryKeyColumn.getFullName().compareTo(columnRef.getPrimaryKeyColumn().getFullName());
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.getFullName().compareTo(columnRef.getForeignKeyColumn().getFullName());
        }
        return compare;
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public final int hashCode() {
        return Objects.hash(this.foreignKeyColumn, this.primaryKeyColumn);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)obj;
        return Objects.equals(this.foreignKeyColumn, other.getForeignKeyColumn()) && Objects.equals(this.primaryKeyColumn, other.getPrimaryKeyColumn());
    }

    public String toString() {
        return this.primaryKeyColumn + " <-- " + this.foreignKeyColumn;
    }
}

