/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.analysis.counts.CatalogWithCounts;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaListFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextFormatter;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;

public final class SchemaTextRenderer
extends BaseSchemaCrawlerCommand {
    private SchemaTextOptions schemaTextOptions;

    public SchemaTextRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadSchemaTextOptions();
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Catalog aCatalog = this.catalog;
        if (this.schemaTextOptions.isShowWeakAssociations()) {
            aCatalog = new CatalogWithAssociations(aCatalog);
        }
        if (this.schemaTextOptions.isShowRowCounts() || this.schemaCrawlerOptions.isNoEmptyTables()) {
            aCatalog = new CatalogWithCounts(aCatalog, this.connection, this.schemaCrawlerOptions);
        }
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler();
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(aCatalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(this.schemaTextOptions.isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(this.schemaTextOptions.isAlphabeticalSortForRoutines()));
        traverser.traverse();
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    public SchemaTextOptions getSchemaTextOptions() {
        return this.schemaTextOptions;
    }

    public final void setSchemaTextOptions(SchemaTextOptions schemaTextOptions) {
        this.schemaTextOptions = Objects.requireNonNull(schemaTextOptions, "No schema text options provided");
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        BaseFormatter formatter = schemaTextDetailType == SchemaTextDetailType.list ? new SchemaListFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString) : new SchemaTextFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private void loadSchemaTextOptions() {
        if (this.schemaTextOptions == null) {
            this.schemaTextOptions = ((SchemaTextOptionsBuilder)SchemaTextOptionsBuilder.builder().fromConfig(this.additionalConfiguration)).toOptions();
        }
    }
}

