/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.iosource.FileOutputResource;
import schemacrawler.tools.iosource.OutputResource;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class OutputOptions
implements Options {
    private final Charset inputEncodingCharset;
    private final Charset outputEncodingCharset;
    private final String outputFormatValue;
    private final OutputResource outputResource;
    private final String title;

    OutputOptions(Charset inputEncodingCharset, OutputResource outputResource, Charset outputEncodingCharset, String outputFormatValue, String title) {
        this.inputEncodingCharset = Objects.requireNonNull(inputEncodingCharset, "No input encoding provided");
        this.outputResource = Objects.requireNonNull(outputResource, "No output resource provided");
        this.outputEncodingCharset = Objects.requireNonNull(outputEncodingCharset, "No output encoding provided");
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Charset getInputCharset() {
        return this.inputEncodingCharset;
    }

    public Charset getOutputCharset() {
        return this.outputEncodingCharset;
    }

    public Path getOutputFile(String extension) {
        Path outputFile;
        if (this.outputResource instanceof FileOutputResource) {
            outputFile = ((FileOutputResource)this.outputResource).getOutputFile();
        } else {
            String fileExtension = Utility.isBlank(extension) ? "" : extension;
            outputFile = Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), fileExtension)).normalize().toAbsolutePath();
        }
        return outputFile;
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Writer openNewOutputWriter() throws IOException {
        return this.openNewOutputWriter(false);
    }

    public Writer openNewOutputWriter(boolean appendOutput) throws IOException {
        return this.outputResource.openNewOutputWriter(this.getOutputCharset(), appendOutput);
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    OutputResource getOutputResource() {
        return this.outputResource;
    }
}

