/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandProviderUtility;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphRenderer;
import schemacrawler.tools.options.OutputOptions;
import sf.util.Utility;

public final class GraphCommandProvider
extends BaseCommandProvider {
    public GraphCommandProvider() {
        super(CommandProviderUtility.schemaTextCommands());
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) {
        return new GraphRenderer(command);
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfiguration, OutputOptions outputOptions) {
        if (outputOptions == null) {
            return false;
        }
        String format = outputOptions.getOutputFormatValue();
        if (Utility.isBlank(format)) {
            return false;
        }
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.fromFormat(format);
        boolean supportsSchemaCrawlerCommand = this.supportsCommand(command) && GraphOutputFormat.isSupportedFormat(format) && graphOutputFormat != GraphOutputFormat.htmlx;
        return supportsSchemaCrawlerCommand;
    }
}

