/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Reducible;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.executable.CommandDaisyChain;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class SchemaCrawlerExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerExecutable.class.getName());
    private final String command;
    private Config additionalConfiguration;
    private Catalog catalog;
    private Connection connection;
    private OutputOptions outputOptions;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private SchemaRetrievalOptions schemaRetrievalOptions;

    public SchemaCrawlerExecutable(String command) {
        if (Utility.isBlank(command)) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = command;
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
        this.additionalConfiguration = new Config();
    }

    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions == null ? SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions() : schemaCrawlerOptions;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions == null ? OutputOptionsBuilder.newOutputOptions() : outputOptions;
    }

    public final void execute() throws Exception {
        if (this.schemaRetrievalOptions == null) {
            this.schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(this.connection);
        }
        SchemaCrawlerCommand scCommand = this.loadCommand();
        scCommand.initialize();
        scCommand.checkAvailability();
        if (this.catalog == null) {
            this.loadCatalog();
        }
        this.reduceCatalog();
        scCommand.setCatalog(this.catalog);
        scCommand.setConnection(this.connection);
        scCommand.execute();
    }

    public boolean hasConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            boolean closed = this.connection.isClosed();
            return !closed;
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public final void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = new Config(additionalConfiguration);
    }

    public void setConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public final String toString() {
        return this.command;
    }

    private void loadCatalog() throws Exception {
        CatalogLoaderRegistry catalogLoaderRegistry = new CatalogLoaderRegistry();
        CatalogLoader catalogLoader = catalogLoaderRegistry.lookupCatalogLoader(this.schemaRetrievalOptions.getDatabaseServerType().getDatabaseSystemIdentifier());
        LOGGER.log(Level.CONFIG, new StringFormat("Catalog loader: %s", this.getClass().getName()));
        catalogLoader.setAdditionalConfiguration(this.additionalConfiguration);
        catalogLoader.setConnection(this.connection);
        catalogLoader.setSchemaRetrievalOptions(this.schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        this.catalog = catalogLoader.loadCatalog();
        Objects.requireNonNull(this.catalog, "Catalog could not be retrieved");
    }

    private SchemaCrawlerCommand loadCommand() throws SchemaCrawlerException {
        CommandDaisyChain scCommand = new CommandDaisyChain(this.command);
        scCommand.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        scCommand.setOutputOptions(this.outputOptions);
        scCommand.setAdditionalConfiguration(this.additionalConfiguration);
        scCommand.setIdentifiers(this.schemaRetrievalOptions.getIdentifiers());
        return scCommand;
    }

    private void reduceCatalog() {
        ((Reducible)((Object)this.catalog)).reduce(Schema.class, ReducerFactory.getSchemaReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)this.catalog)).reduce(Table.class, ReducerFactory.getTableReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)this.catalog)).reduce(Routine.class, ReducerFactory.getRoutineReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)this.catalog)).reduce(Synonym.class, ReducerFactory.getSynonymReducer(this.schemaCrawlerOptions));
        ((Reducible)((Object)this.catalog)).reduce(Sequence.class, ReducerFactory.getSequenceReducer(this.schemaCrawlerOptions));
    }
}

