/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import sf.util.Utility;

public final class SchemaCrawlerOptionsBuilder
implements OptionsBuilder<SchemaCrawlerOptionsBuilder, SchemaCrawlerOptions> {
    private static final String SC_COLUMN_PATTERN_EXCLUDE = "schemacrawler.column.pattern.exclude";
    private static final String SC_COLUMN_PATTERN_INCLUDE = "schemacrawler.column.pattern.include";
    private static final String SC_GREP_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.column.pattern.exclude";
    private static final String SC_GREP_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.column.pattern.include";
    private static final String SC_GREP_DEFINITION_PATTERN_EXCLUDE = "schemacrawler.grep.definition.pattern.exclude";
    private static final String SC_GREP_DEFINITION_PATTERN_INCLUDE = "schemacrawler.grep.definition.pattern.include";
    private static final String SC_GREP_ROUTINE_PARAMETER_PATTERN_EXCLUDE = "schemacrawler.grep.routine.inout.pattern.exclude";
    private static final String SC_GREP_ROUTINE_PARAMETER_PATTERN_INCLUDE = "schemacrawler.grep.routine.inout.pattern.include";
    private static final String SC_ROUTINE_PARAMETER_PATTERN_EXCLUDE = "schemacrawler.routine.inout.pattern.exclude";
    private static final String SC_ROUTINE_PARAMETER_PATTERN_INCLUDE = "schemacrawler.routine.inout.pattern.include";
    private static final String SC_ROUTINE_PATTERN_EXCLUDE = "schemacrawler.routine.pattern.exclude";
    private static final String SC_ROUTINE_PATTERN_INCLUDE = "schemacrawler.routine.pattern.include";
    private static final String SC_SCHEMA_PATTERN_EXCLUDE = "schemacrawler.schema.pattern.exclude";
    private static final String SC_SCHEMA_PATTERN_INCLUDE = "schemacrawler.schema.pattern.include";
    private static final String SC_SEQUENCE_PATTERN_EXCLUDE = "schemacrawler.sequence.pattern.exclude";
    private static final String SC_SEQUENCE_PATTERN_INCLUDE = "schemacrawler.sequence.pattern.include";
    private static final String SC_SYNONYM_PATTERN_EXCLUDE = "schemacrawler.synonym.pattern.exclude";
    private static final String SC_SYNONYM_PATTERN_INCLUDE = "schemacrawler.synonym.pattern.include";
    private static final String SC_TABLE_PATTERN_EXCLUDE = "schemacrawler.table.pattern.exclude";
    private static final String SC_TABLE_PATTERN_INCLUDE = "schemacrawler.table.pattern.include";
    private int childTableFilterDepth;
    private InclusionRule columnInclusionRule;
    private Optional<InclusionRule> grepColumnInclusionRule;
    private Optional<InclusionRule> grepDefinitionInclusionRule;
    private boolean grepInvertMatch;
    private boolean grepOnlyMatching;
    private Optional<InclusionRule> grepRoutineParameterInclusionRule;
    private boolean isNoEmptyTables;
    private int parentTableFilterDepth;
    private InclusionRule routineInclusionRule;
    private InclusionRule routineParameterInclusionRule;
    private Optional<Collection<RoutineType>> routineTypes;
    private InclusionRule schemaInclusionRule;
    private SchemaInfoLevelBuilder schemaInfoLevelBuilder = SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.standard);
    private InclusionRule sequenceInclusionRule;
    private InclusionRule synonymInclusionRule;
    private InclusionRule tableInclusionRule;
    private String tableNamePattern;
    private Optional<Collection<String>> tableTypes;

    private static Collection<RoutineType> allRoutineTypes() {
        return EnumSet.of(RoutineType.procedure, RoutineType.function);
    }

    public static SchemaCrawlerOptionsBuilder builder() {
        return new SchemaCrawlerOptionsBuilder();
    }

    private static Collection<String> defaultTableTypes() {
        return Arrays.asList("BASE TABLE", "TABLE", "VIEW");
    }

    public static SchemaCrawlerOptions newSchemaCrawlerOptions() {
        return SchemaCrawlerOptionsBuilder.builder().toOptions();
    }

    private SchemaCrawlerOptionsBuilder() {
        this.schemaInclusionRule = new IncludeAll();
        this.synonymInclusionRule = new ExcludeAll();
        this.sequenceInclusionRule = new ExcludeAll();
        this.tableTypes = Optional.of(SchemaCrawlerOptionsBuilder.defaultTableTypes());
        this.tableInclusionRule = new IncludeAll();
        this.columnInclusionRule = new IncludeAll();
        this.routineTypes = Optional.of(SchemaCrawlerOptionsBuilder.allRoutineTypes());
        this.routineInclusionRule = new ExcludeAll();
        this.routineParameterInclusionRule = new ExcludeAll();
        this.grepColumnInclusionRule = Optional.empty();
        this.grepRoutineParameterInclusionRule = Optional.empty();
        this.grepDefinitionInclusionRule = Optional.empty();
    }

    public SchemaCrawlerOptionsBuilder childTableFilterDepth(int childTableFilterDepth) {
        this.childTableFilterDepth = childTableFilterDepth < 0 ? 0 : childTableFilterDepth;
        return this;
    }

    public SchemaCrawlerOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        this.schemaInfoLevelBuilder = SchemaInfoLevelBuilder.builder().fromConfig(config);
        this.schemaInclusionRule = config.getInclusionRuleWithDefault(SC_SCHEMA_PATTERN_INCLUDE, SC_SCHEMA_PATTERN_EXCLUDE, IncludeAll::new);
        this.synonymInclusionRule = config.getInclusionRuleWithDefault(SC_SYNONYM_PATTERN_INCLUDE, SC_SYNONYM_PATTERN_EXCLUDE, ExcludeAll::new);
        this.sequenceInclusionRule = config.getInclusionRuleWithDefault(SC_SEQUENCE_PATTERN_INCLUDE, SC_SEQUENCE_PATTERN_EXCLUDE, ExcludeAll::new);
        this.tableInclusionRule = config.getInclusionRuleWithDefault(SC_TABLE_PATTERN_INCLUDE, SC_TABLE_PATTERN_EXCLUDE, IncludeAll::new);
        this.columnInclusionRule = config.getInclusionRuleWithDefault(SC_COLUMN_PATTERN_INCLUDE, SC_COLUMN_PATTERN_EXCLUDE, IncludeAll::new);
        this.routineInclusionRule = config.getInclusionRuleWithDefault(SC_ROUTINE_PATTERN_INCLUDE, SC_ROUTINE_PATTERN_EXCLUDE, ExcludeAll::new);
        this.routineParameterInclusionRule = config.getInclusionRuleWithDefault(SC_ROUTINE_PARAMETER_PATTERN_INCLUDE, SC_ROUTINE_PARAMETER_PATTERN_EXCLUDE, IncludeAll::new);
        this.grepColumnInclusionRule = config.getOptionalInclusionRule(SC_GREP_COLUMN_PATTERN_INCLUDE, SC_GREP_COLUMN_PATTERN_EXCLUDE);
        this.grepRoutineParameterInclusionRule = config.getOptionalInclusionRule(SC_GREP_ROUTINE_PARAMETER_PATTERN_INCLUDE, SC_GREP_ROUTINE_PARAMETER_PATTERN_EXCLUDE);
        this.grepDefinitionInclusionRule = config.getOptionalInclusionRule(SC_GREP_DEFINITION_PATTERN_INCLUDE, SC_GREP_DEFINITION_PATTERN_EXCLUDE);
        return this;
    }

    public SchemaCrawlerOptionsBuilder fromOptions(SchemaCrawlerOptions options) {
        if (options == null) {
            return this;
        }
        this.schemaInfoLevelBuilder = SchemaInfoLevelBuilder.builder().fromOptions(options.getSchemaInfoLevel());
        this.schemaInclusionRule = options.getSchemaInclusionRule();
        this.synonymInclusionRule = options.getSynonymInclusionRule();
        this.sequenceInclusionRule = options.getSequenceInclusionRule();
        this.tableTypes = Optional.ofNullable(options.getTableTypes());
        this.tableNamePattern = options.getTableNamePattern();
        this.tableInclusionRule = options.getTableInclusionRule();
        this.columnInclusionRule = options.getColumnInclusionRule();
        this.routineTypes = Optional.ofNullable(options.getRoutineTypes());
        this.routineInclusionRule = options.getRoutineInclusionRule();
        this.routineParameterInclusionRule = options.getRoutineParameterInclusionRule();
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(options.getGrepRoutineParameterInclusionRule()).orElse(null);
        this.grepDefinitionInclusionRule = Optional.ofNullable(options.getGrepDefinitionInclusionRule()).orElse(null);
        this.grepInvertMatch = options.isGrepInvertMatch();
        this.grepOnlyMatching = options.isGrepOnlyMatching();
        this.isNoEmptyTables = options.isNoEmptyTables();
        this.childTableFilterDepth = options.getChildTableFilterDepth();
        this.parentTableFilterDepth = options.getParentTableFilterDepth();
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaCrawlerOptions toOptions() {
        if (this.tableInclusionRule instanceof ExcludeAll) {
            this.schemaInfoLevelBuilder.withoutTables();
        }
        if (this.routineInclusionRule instanceof ExcludeAll) {
            this.schemaInfoLevelBuilder.withoutRoutines();
        }
        return new SchemaCrawlerOptions(this.schemaInfoLevelBuilder.toOptions(), this.schemaInclusionRule, this.synonymInclusionRule, this.sequenceInclusionRule, this.tableTypes.orElse(null), this.tableNamePattern, this.tableInclusionRule, this.columnInclusionRule, this.routineTypes.orElse(null), this.routineInclusionRule, this.routineParameterInclusionRule, this.grepColumnInclusionRule.orElse(null), this.grepRoutineParameterInclusionRule.orElse(null), this.grepDefinitionInclusionRule.orElse(null), this.grepInvertMatch, this.grepOnlyMatching, this.isNoEmptyTables, this.childTableFilterDepth, this.parentTableFilterDepth);
    }

    public SchemaCrawlerOptionsBuilder grepOnlyMatching(boolean grepOnlyMatching) {
        this.grepOnlyMatching = grepOnlyMatching;
        return this;
    }

    @Deprecated
    public final SchemaCrawlerOptionsBuilder hideEmptyTables() {
        return this.noEmptyTables(true);
    }

    @Deprecated
    public final SchemaCrawlerOptionsBuilder hideEmptyTables(boolean value) {
        return this.noEmptyTables(value);
    }

    public SchemaCrawlerOptionsBuilder includeAllRoutines() {
        this.includeRoutines(new IncludeAll());
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeAllSequences() {
        this.includeSequences(new IncludeAll());
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeAllSynonyms() {
        this.includeSynonyms(new IncludeAll());
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeColumns(InclusionRule columnInclusionRule) {
        this.columnInclusionRule = columnInclusionRule == null ? new IncludeAll() : columnInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedColumns(InclusionRule grepColumnInclusionRule) {
        this.grepColumnInclusionRule = Optional.ofNullable(grepColumnInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSchemas(Pattern schemaPattern) {
        this.schemaInclusionRule = new RegularExpressionInclusionRule(schemaPattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeTables(Pattern tablePattern) {
        this.tableInclusionRule = new RegularExpressionInclusionRule(tablePattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeRoutines(Pattern routinePattern) {
        this.routineInclusionRule = new RegularExpressionInclusionRule(routinePattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSequences(Pattern sequencePattern) {
        this.sequenceInclusionRule = new RegularExpressionInclusionRule(sequencePattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSynonyms(Pattern synonymPattern) {
        this.synonymInclusionRule = new RegularExpressionInclusionRule(synonymPattern);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedColumns(Pattern grepColumnPattern) {
        this.grepColumnInclusionRule = grepColumnPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepColumnPattern));
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedDefinitions(InclusionRule grepDefinitionInclusionRule) {
        this.grepDefinitionInclusionRule = Optional.ofNullable(grepDefinitionInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedDefinitions(Pattern grepDefinitionPattern) {
        this.grepDefinitionInclusionRule = grepDefinitionPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepDefinitionPattern));
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedRoutineParameters(InclusionRule grepRoutineParameterInclusionRule) {
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(grepRoutineParameterInclusionRule);
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeGreppedRoutineParameters(Pattern grepRoutineParametersPattern) {
        this.grepRoutineParameterInclusionRule = grepRoutineParametersPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepRoutineParametersPattern));
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeRoutineParameters(InclusionRule routineParameterInclusionRule) {
        this.routineParameterInclusionRule = routineParameterInclusionRule == null ? new IncludeAll() : routineParameterInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeRoutines(InclusionRule routineInclusionRule) {
        if (routineInclusionRule == null) {
            this.routineInclusionRule = new ExcludeAll();
            this.routineParameterInclusionRule = new ExcludeAll();
        } else {
            this.routineInclusionRule = routineInclusionRule;
            this.routineParameterInclusionRule = new IncludeAll();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSchemas(InclusionRule schemaInclusionRule) {
        this.schemaInclusionRule = schemaInclusionRule == null ? new IncludeAll() : schemaInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSequences(InclusionRule sequenceInclusionRule) {
        this.sequenceInclusionRule = sequenceInclusionRule == null ? new ExcludeAll() : sequenceInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeSynonyms(InclusionRule synonymInclusionRule) {
        this.synonymInclusionRule = synonymInclusionRule == null ? new ExcludeAll() : synonymInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder includeTables(InclusionRule tableInclusionRule) {
        this.tableInclusionRule = tableInclusionRule == null ? new IncludeAll() : tableInclusionRule;
        return this;
    }

    public SchemaCrawlerOptionsBuilder invertGrepMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
        return this;
    }

    public final SchemaCrawlerOptionsBuilder noEmptyTables() {
        return this.noEmptyTables(true);
    }

    public final SchemaCrawlerOptionsBuilder noEmptyTables(boolean value) {
        this.isNoEmptyTables = value;
        return this;
    }

    public SchemaCrawlerOptionsBuilder parentTableFilterDepth(int parentTableFilterDepth) {
        this.parentTableFilterDepth = parentTableFilterDepth < 0 ? 0 : parentTableFilterDepth;
        return this;
    }

    public SchemaCrawlerOptionsBuilder routineTypes(Collection<RoutineType> routineTypes) {
        this.routineTypes = routineTypes == null ? Optional.empty() : (routineTypes.isEmpty() ? Optional.of(Collections.emptySet()) : Optional.of(new HashSet<RoutineType>(routineTypes)));
        return this;
    }

    public SchemaCrawlerOptionsBuilder routineTypes(String routineTypesString) {
        if (routineTypesString != null) {
            HashSet<RoutineType> routineTypes = new HashSet<RoutineType>();
            String[] routineTypeStrings = routineTypesString.split(",");
            if (routineTypeStrings != null && routineTypeStrings.length > 0) {
                for (String routineTypeString : routineTypeStrings) {
                    RoutineType routineType = Utility.enumValue(routineTypeString.toLowerCase(Locale.ENGLISH), RoutineType.unknown);
                    routineTypes.add(routineType);
                }
            }
            this.routineTypes = Optional.of(routineTypes);
        } else {
            this.routineTypes = Optional.empty();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableNamePattern(String tableNamePattern) {
        this.tableNamePattern = Utility.isBlank(tableNamePattern) ? null : tableNamePattern;
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes == null ? Optional.empty() : (tableTypes.isEmpty() ? Optional.of(Collections.emptySet()) : Optional.of(new HashSet<String>(tableTypes)));
        return this;
    }

    public SchemaCrawlerOptionsBuilder tableTypes(String tableTypesString) {
        if (tableTypesString != null) {
            HashSet<String> tableTypes = new HashSet<String>();
            String[] tableTypeStrings = tableTypesString.split(",");
            if (tableTypeStrings != null && tableTypeStrings.length > 0) {
                for (String tableTypeString : tableTypeStrings) {
                    tableTypes.add(tableTypeString.trim());
                }
            }
            this.tableTypes = Optional.of(tableTypes);
        } else {
            this.tableTypes = Optional.empty();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        if (schemaInfoLevel != null) {
            this.schemaInfoLevelBuilder = SchemaInfoLevelBuilder.builder().fromOptions(schemaInfoLevel);
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withSchemaInfoLevel(SchemaInfoLevelBuilder schemaInfoLevelBuilder) {
        this.schemaInfoLevelBuilder = schemaInfoLevelBuilder == null ? SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.standard) : schemaInfoLevelBuilder;
        return this;
    }
}

