/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.utility.Identifiers;
import sf.util.Utility;

public final class SchemaReference
implements Schema {
    private static final long serialVersionUID = -5309848447599233878L;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final String catalogName;
    private final String schemaName;
    private transient String fullName;

    public SchemaReference() {
        this(null, null);
    }

    public SchemaReference(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public int compareTo(NamedObject otherSchemaRef) {
        if (otherSchemaRef == null) {
            return -1;
        }
        return Utility.convertForComparison(this.getFullName()).compareTo(Utility.convertForComparison(otherSchemaRef.getFullName()));
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.attributeMap.get(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public final void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public List<String> toUniqueLookupKey() {
        return new ArrayList<String>(Arrays.asList(this.catalogName, this.schemaName));
    }

    @Override
    public String getRemarks() {
        return "";
    }

    @Override
    public boolean hasRemarks() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaReference)) {
            return false;
        }
        Schema other = (Schema)obj;
        return Objects.equals(this.catalogName, other.getCatalogName()) && Objects.equals(this.schemaName, other.getName());
    }

    public String toString() {
        return this.getFullName();
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
        this.fullName = identifiers.quoteFullName(this);
    }
}

