/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;

final class TablePartial
extends AbstractDatabaseObject
implements Table,
PartialDatabaseObject {
    private static final long serialVersionUID = -5968964551235088703L;
    private Column column;
    private ForeignKey foreignKey;

    TablePartial(Schema schema, String tableName) {
        super(schema, tableName);
    }

    TablePartial(Table table) {
        this(Objects.requireNonNull(table, "No table provided").getSchema(), table.getName());
        this.addAttributes(table.getAttributes());
    }

    @Override
    public List<Column> getColumns() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<ForeignKey> getExportedForeignKeys() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<Column> getHiddenColumns() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<ForeignKey> getImportedForeignKeys() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<Index> getIndexes() {
        throw new NotLoadedException(this);
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<Privilege<Table>> getPrivileges() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<TableConstraint> getTableConstraints() {
        throw new NotLoadedException(this);
    }

    @Override
    public TableType getTableType() {
        throw new NotLoadedException(this);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        throw new NotLoadedException(this);
    }

    @Override
    public final boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public Optional<Column> lookupColumn(String name) {
        if (this.column.getName().equals(name)) {
            return Optional.ofNullable(this.column);
        }
        return Optional.empty();
    }

    public Optional<ForeignKey> lookupForeignKey(String name) {
        if (this.foreignKey.getName().equals(name)) {
            return Optional.ofNullable(this.foreignKey);
        }
        return Optional.empty();
    }

    public Optional<Index> lookupIndex(String name) {
        throw new NotLoadedException(this);
    }

    public Optional<? extends Privilege<Table>> lookupPrivilege(String name) {
        throw new NotLoadedException(this);
    }

    public Optional<Trigger> lookupTrigger(String name) {
        throw new NotLoadedException(this);
    }

    @Override
    public String getDefinition() {
        throw new NotLoadedException(this);
    }

    @Override
    public boolean hasDefinition() {
        throw new NotLoadedException(this);
    }

    @Override
    public TableType getType() {
        throw new NotLoadedException(this);
    }

    void addColumn(Column column) {
        this.column = column;
    }

    void addForeignKey(ForeignKey foreignKey) {
        this.foreignKey = foreignKey;
    }
}

