/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TableTypes;
import schemacrawler.utility.TypeMap;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class RetrieverConnection {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RetrieverConnection.class.getName());
    private final Connection connection;
    private final JavaSqlTypes javaSqlTypes;
    private final DatabaseMetaData metaData;
    private final SchemaRetrievalOptions schemaRetrievalOptions;
    private final TableTypes tableTypes;

    RetrieverConnection(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions) throws SQLException {
        this.connection = DatabaseUtility.checkConnection(connection);
        this.metaData = connection.getMetaData();
        this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database specific overrides provided");
        this.tableTypes = new TableTypes(connection);
        LOGGER.log(Level.CONFIG, new StringFormat("Supported table types are <%s>", this.tableTypes));
        this.javaSqlTypes = new JavaSqlTypes();
    }

    Connection getConnection() {
        return this.connection;
    }

    MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.schemaRetrievalOptions.getForeignKeyRetrievalStrategy();
    }

    MetadataRetrievalStrategy getFunctionColumnRetrievalStrategy() {
        return this.schemaRetrievalOptions.getFunctionColumnRetrievalStrategy();
    }

    MetadataRetrievalStrategy getFunctionRetrievalStrategy() {
        return this.schemaRetrievalOptions.getFunctionRetrievalStrategy();
    }

    MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.schemaRetrievalOptions.getIndexRetrievalStrategy();
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.schemaRetrievalOptions.getInformationSchemaViews();
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.schemaRetrievalOptions.getPrimaryKeyRetrievalStrategy();
    }

    MetadataRetrievalStrategy getProcedureColumnRetrievalStrategy() {
        return this.schemaRetrievalOptions.getProcedureColumnRetrievalStrategy();
    }

    MetadataRetrievalStrategy getProcedureRetrievalStrategy() {
        return this.schemaRetrievalOptions.getProcedureRetrievalStrategy();
    }

    MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.schemaRetrievalOptions.getTableColumnRetrievalStrategy();
    }

    MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.schemaRetrievalOptions.getTableRetrievalStrategy();
    }

    TableTypes getTableTypes() {
        return this.tableTypes;
    }

    TypeMap getTypeMap() {
        return this.schemaRetrievalOptions.getTypeMap();
    }

    boolean isSupportsCatalogs() {
        return this.schemaRetrievalOptions.isSupportsCatalogs();
    }

    boolean isSupportsSchemas() {
        return this.schemaRetrievalOptions.isSupportsSchemas();
    }
}

