/*
 * This file is part of AceQL JDBC Driver.
 * AceQL JDBC Driver: Remote JDBC access over HTTP with AceQL HTTP.
 * Copyright (c) 2023,  KawanSoft SAS
 * (http://www.kawansoft.com). All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aceql.jdbc.commons.main;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

import com.aceql.jdbc.commons.AceQLBlob;
import com.aceql.jdbc.commons.InternalWrapper;
import com.aceql.jdbc.commons.main.util.framework.Tag;

/**
 * Utility class for Blob that must be in same package than
 * AceQLPreparedStatement.
 *
 * @author Nicolas de Pomereu
 *
 */
class AceQLBlobUtil {

    private Blob x;

    public AceQLBlobUtil(Blob x) {
	this.x = x;
    }

    /**
     * Gets the InputStream of Blob
     *
     * @param x
     * @param connection
     * @return
     * @throws SQLException
     */
    InputStream getInputStreamFromBlob() throws SQLException {
	if (x == null) {
	    return null;
	}

	if (x instanceof AceQLBlob) {
	    AceQLBlob blob = (AceQLBlob) x;
	    InputStream input = getInputStreamFromBlob(blob);
	    return input;
	}
	else {
	    return x.getBinaryStream();
	}
    }

    /**
     * Gets the byte array
     *
     * @return
     * @throws SQLException
     */
    byte[] getBytesFromBlob() throws SQLException {
	if (x == null) {
	    return null;
	}
	return x.getBytes(1, (int) x.length());
    }

    /**
     * @param file
     * @return
     * @throws SQLException
     */
    private static InputStream getInputStreamFromBlob(AceQLBlob blob) throws SQLException {
	// Keep for now:File file = blob.getFile();
	File file =  InternalWrapper.getFile(blob);
	if (file == null) {
	    throw new SQLException(Tag.PRODUCT + " " + "The underlying file of the Blob is null.");
	}

	if (!file.exists()) {
	    throw new SQLException(Tag.PRODUCT + " " + "The underlying file of the Blob does not exist: " + file);
	}

	InputStream input = null;
	try {
	    input = new BufferedInputStream(new FileInputStream(file));
	} catch (IOException ioe) {
	    throw new SQLException(Tag.PRODUCT + " " + "Can not process the Blob file " + file
		    + ". IOException raised: " + ioe.getMessage());
	}
	return input;
    }

}
