/*
 * The MIT License
 *
 * Copyright 2020 Universitas Teknologi Yogyakarta.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package arsip.surat.view;

import arsip.surat.service.LoginService;
import arsip.surat.util.DragWindowUtil;
import arsip.surat.util.PreferencedHelper;
import java.awt.Frame;
import javax.swing.JOptionPane;

/**
 *
 * @author Muhammad Rosyid Izzulkhaq (rsdiz)
 */
public class LoginView extends javax.swing.JFrame {

    private static LoginView loginView;
    private final LoginService loginService = new LoginService();

    /**
     * Creates new form LoginView
     */
    private LoginView() {
        initComponents();
        new DragWindowUtil().enable(LoginView.this);
    }

    /**
     * Singleton pattern
     * <editor-fold defaultstate="collapsed" desc="Singleton pattern">
     * 
     * @return 
     */
    public static LoginView getInstance() {
        if (loginView == null) {
            loginView = new LoginView();
        }
        return loginView;
    } // </editor-fold>
    /**
     * <editor-fold defaultstate="collapsed" desc="Membersihkan instance yang sudah dibuat">
     * Membersihkan instance yang sudah dibuat
     */
    public static void clearInstance() {
        if (loginView != null) {
            loginView = null;
        }
    } // </editor-fold>

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        basePanel = new javax.swing.JPanel();
        customTitleBar = new javax.swing.JPanel();
        title_text = new javax.swing.JLabel();
        minimizedIcon = new javax.swing.JLabel();
        exitIcon = new javax.swing.JLabel();
        contentPanel = new javax.swing.JPanel();
        loginPanel = new javax.swing.JPanel();
        passwordPanel = new javax.swing.JPanel();
        passwordTextField = new javax.swing.JPasswordField();
        passwordIcon = new javax.swing.JLabel();
        usernamePanel = new javax.swing.JPanel();
        usernameTextField = new javax.swing.JTextField();
        usernameIcon = new javax.swing.JLabel();
        btnMasuk = new javax.swing.JButton();
        chk_login = new javax.swing.JCheckBox();
        login_text = new javax.swing.JLabel();
        separator = new javax.swing.JSeparator();
        copyright_text = new javax.swing.JLabel();
        made_with_love = new javax.swing.JLabel();
        version_text = new javax.swing.JLabel();
        aboutDeveloper = new javax.swing.JLabel();
        background = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("E-Arsip Surat: Login");
        setLocationByPlatform(true);
        setMaximumSize(new java.awt.Dimension(800, 600));
        setMinimumSize(new java.awt.Dimension(800, 600));
        setName("frame-login"); // NOI18N
        setUndecorated(true);
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        basePanel.setBackground(new java.awt.Color(255, 255, 255));
        basePanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        basePanel.setFocusCycleRoot(true);
        basePanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        customTitleBar.setBackground(new java.awt.Color(242, 242, 242));
        customTitleBar.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        title_text.setFont(new java.awt.Font("monogram", 0, 28)); // NOI18N
        title_text.setForeground(new java.awt.Color(20, 20, 20));
        title_text.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        title_text.setText("E-Arsip Surat");
        customTitleBar.add(title_text, new org.netbeans.lib.awtextra.AbsoluteConstraints(215, 0, 360, 50));

        minimizedIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized~1.png"))); // NOI18N
        minimizedIcon.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                minimizedIconMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                minimizedIconMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                minimizedIconMouseExited(evt);
            }
        });
        customTitleBar.add(minimizedIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(720, 0, 30, 50));

        exitIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close~1.png"))); // NOI18N
        exitIcon.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exitIconMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                exitIconMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                exitIconMouseExited(evt);
            }
        });
        customTitleBar.add(exitIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(750, 0, 30, 50));

        basePanel.add(customTitleBar, new org.netbeans.lib.awtextra.AbsoluteConstraints(5, 5, 790, 50));

        contentPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                contentPanelMouseClicked(evt);
            }
        });
        contentPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        loginPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(255, 255, 255), 4));
        loginPanel.setPreferredSize(new java.awt.Dimension(350, 420));
        loginPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        passwordPanel.setBackground(new java.awt.Color(210, 210, 210));
        passwordPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        passwordTextField.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        passwordTextField.setText("password");
        passwordTextField.setFocusCycleRoot(true);
        passwordTextField.setMargin(new java.awt.Insets(2, 12, 2, 12));
        passwordTextField.setNextFocusableComponent(chk_login);
        passwordPanel.add(passwordTextField, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 10, 240, 50));

        passwordIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/unlocked~1.png"))); // NOI18N
        passwordPanel.add(passwordIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(15, 20, -1, -1));

        loginPanel.add(passwordPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 190, 310, 70));

        usernamePanel.setBackground(new java.awt.Color(210, 210, 210));
        usernamePanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        usernameTextField.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        usernameTextField.setForeground(new java.awt.Color(55, 55, 55));
        usernameTextField.setText("Username/Email");
        usernameTextField.setFocusCycleRoot(true);
        usernameTextField.setMargin(new java.awt.Insets(2, 12, 2, 12));
        usernameTextField.setNextFocusableComponent(passwordTextField);
        usernamePanel.add(usernameTextField, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 10, 240, 50));

        usernameIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/user~1.png"))); // NOI18N
        usernamePanel.add(usernameIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(15, 20, -1, -1));

        loginPanel.add(usernamePanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 100, 310, 70));

        btnMasuk.setFont(new java.awt.Font("monogram", 0, 36)); // NOI18N
        btnMasuk.setText("MASUK");
        btnMasuk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnMasukActionPerformed(evt);
            }
        });
        loginPanel.add(btnMasuk, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 330, 290, 60));

        chk_login.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        chk_login.setText("Biarkan saya tetap masuk?");
        chk_login.setToolTipText("<html>Ketika anda membuka aplikasi ini dikemudian hari,<br>\nanda tidak perlu memasukkan password kembali.</html>");
        chk_login.setNextFocusableComponent(btnMasuk);
        loginPanel.add(chk_login, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 280, 190, 30));

        login_text.setFont(new java.awt.Font("monogram", 0, 36)); // NOI18N
        login_text.setForeground(new java.awt.Color(10, 10, 10));
        login_text.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        login_text.setText("Login");
        login_text.setFocusCycleRoot(true);
        loginPanel.add(login_text, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 20, 310, 50));
        loginPanel.add(separator, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 80, 310, 10));

        contentPanel.add(loginPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(220, 20, -1, -1));

        copyright_text.setFont(new java.awt.Font("monogram", 0, 20)); // NOI18N
        copyright_text.setForeground(new java.awt.Color(100, 100, 100));
        copyright_text.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        copyright_text.setText("Copyright 2020 UTY Hebat");
        contentPanel.add(copyright_text, new org.netbeans.lib.awtextra.AbsoluteConstraints(220, 450, 350, 40));

        made_with_love.setFont(new java.awt.Font("monogram", 0, 20)); // NOI18N
        made_with_love.setForeground(new java.awt.Color(100, 100, 100));
        made_with_love.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        made_with_love.setText("Made with <3");
        contentPanel.add(made_with_love, new org.netbeans.lib.awtextra.AbsoluteConstraints(330, 490, 130, 20));

        version_text.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        version_text.setForeground(new java.awt.Color(100, 100, 100));
        version_text.setText("Versi 1.0");
        contentPanel.add(version_text, new org.netbeans.lib.awtextra.AbsoluteConstraints(690, 500, -1, -1));

        aboutDeveloper.setFont(new java.awt.Font("Socialico Plus Plus", 0, 48)); // NOI18N
        aboutDeveloper.setForeground(new java.awt.Color(100, 100, 100));
        aboutDeveloper.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        aboutDeveloper.setText("z");
        aboutDeveloper.setToolTipText("About Developer");
        aboutDeveloper.setPreferredSize(new java.awt.Dimension(80, 50));
        aboutDeveloper.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                aboutDeveloperMouseClicked(evt);
            }
        });
        contentPanel.add(aboutDeveloper, new org.netbeans.lib.awtextra.AbsoluteConstraints(690, 450, -1, -1));

        background.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/bg.jpg"))); // NOI18N
        background.setPreferredSize(new java.awt.Dimension(790, 540));
        contentPanel.add(background, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, -1, -1));

        basePanel.add(contentPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(5, 55, 790, 540));

        getContentPane().add(basePanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, 800, 600));

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Merubah gambar icon minimize ketika mouse entered
     * <editor-fold defaultstate="collapsed" desc="Merubah gambar icon minimize ketika mouse entered">
     *
     * @param evt
     */
    private void minimizedIconMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseEntered
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized-hover~1.png")));
    }//GEN-LAST:event_minimizedIconMouseEntered
    // </editor-fold>
    /**
     * Merubah gambar icon minimized seperti semula
     * <editor-fold defaultstate="collapsed" desc="Merubah gambar icon minimized seperti semula">
     *
     * @param evt
     */
    private void minimizedIconMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseExited
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized~1.png")));
    }//GEN-LAST:event_minimizedIconMouseExited
    // </editor-fold>
    /**
     * Mengubah state window menjadi iconified ketika icon diklik
     * <editor-fold defaultstate="collapsed" desc="Mengubah state window menjadi iconified ketika icon diklik">
     *
     * @param evt
     */
    private void minimizedIconMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseClicked
        this.setState(Frame.ICONIFIED);
    }//GEN-LAST:event_minimizedIconMouseClicked
    // </editor-fold>
    /**
     * Merubah gambar icon exit ketika mouse entered
     * <editor-fold defaultstate="collapsed" desc="Merubah gambar icon exit ketika mouse entered">
     *
     * @param evt
     */
    private void exitIconMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseEntered
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close-hover~1.png")));
    }//GEN-LAST:event_exitIconMouseEntered
    // </editor-fold>
    /**
     * Merubah gambar icon exit seperti semula
     * <editor-fold defaultstate="collapsed" desc="Merubah gambar icon exit seperti semula">
     *
     * @param evt
     */
    private void exitIconMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseExited
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close~1.png")));
    }//GEN-LAST:event_exitIconMouseExited
    // </editor-fold>
    /**
     * Aksi ketika tombol diklik, maka aplikasi keluar
     * <editor-fold defaultstate="collapsed" desc="Aksi ketika tombol diklik, maka aplikasi keluar">
     *
     * @param evt
     */
    private void exitIconMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseClicked
        System.exit(0);
    }//GEN-LAST:event_exitIconMouseClicked
    // </editor-fold>
    /**
     * Membuat frame tidak bisa didrag
     * <editor-fold defaultstate="collapsed" desc="Membuat frame tidak bisa didrag">
     *
     * @param evt
     */
    private void contentPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_contentPanelMouseClicked
        // DO NOTHING
    }//GEN-LAST:event_contentPanelMouseClicked
    // </editor-fold>
    /**
     * Menampilkan frame AboutDeveloperView
     * <editor-fold defaultstate="collapsed" desc="Menampilkan frame AboutDeveloperView">
     *
     * @param evt
     */
    private void aboutDeveloperMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_aboutDeveloperMouseClicked
        minimizedIconMouseClicked(evt);
        loginView.setVisible(false);
        AboutDeveloperView.getInstance().setVisible(true);
    }//GEN-LAST:event_aboutDeveloperMouseClicked
    // </editor-fold>
    /**
     * Proses Login
     * <editor-fold defaultstate="collapsed" desc="Proses Login">
     *
     * @param evt
     */
    private void btnMasukActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnMasukActionPerformed
        Thread thread = new Thread("Login-Proccess") {
            @Override
            public void run() {
                String username = usernameTextField.getText();
                String password = String.valueOf(passwordTextField.getPassword());
                boolean stayLogin = chk_login.isSelected();
                if (!username.isEmpty() && !password.isEmpty()) {
                    int doLogin = loginService.loginProcess(username, password, stayLogin);
                    switch (doLogin) {
                        case -1:
                        case 0:
                            JOptionPane.showMessageDialog(LoginView.this,
                                    "Username atau password yang anda masukkan salah!\nSilahkan ulangi kembali!",
                                    "Login Gagal!",
                                     JOptionPane.WARNING_MESSAGE);
                            break;
                        case 1:
                            JOptionPane.showMessageDialog(LoginView.this,
                                    "Berhasil Login!",
                                    "Login Sukses!",
                                     JOptionPane.INFORMATION_MESSAGE);
                            gotoDashboard();
                            break;
                        case 2:
                            JOptionPane.showMessageDialog(LoginView.this,
                                    "Terjadi kesalahan!\nSilahkan ulangi beberapa saat lagi!",
                                    "Error!",
                                     JOptionPane.WARNING_MESSAGE);
                            break;
                    }
                } else {
                    JOptionPane.showMessageDialog(LoginView.this,
                            "Kolom Username atau password tidak boleh kosong!\nSilahkan isi terlebih dahulu!",
                            "Error!",
                            JOptionPane.WARNING_MESSAGE);
                }
            }
        };
        thread.start();
    }//GEN-LAST:event_btnMasukActionPerformed
    // </editor-fold>
    /**
     * Pindah form ke dashboard
     * <editor-fold defaultstate="collapsed" desc="Pindah form ke dashboard">
     */
    private void gotoDashboard() {
        loginView.dispose();
        DashboardView dashboardView = DashboardView.getInstance();
        dashboardView.setVisible(true);
    }
    // </editor-fold>
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(LoginView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        
        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            if (PreferencedHelper.getLogin()) {
                LoginView.getInstance().gotoDashboard();
            } else {
                LoginView.getInstance().setVisible(true);
            }
        });
    }

    // <editor-fold defaultstate="collapsed" desc="Deklarasi Variabel">
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel aboutDeveloper;
    private javax.swing.JLabel background;
    private javax.swing.JPanel basePanel;
    private javax.swing.JButton btnMasuk;
    private javax.swing.JCheckBox chk_login;
    private javax.swing.JPanel contentPanel;
    private javax.swing.JLabel copyright_text;
    private javax.swing.JPanel customTitleBar;
    private javax.swing.JLabel exitIcon;
    private javax.swing.JPanel loginPanel;
    private javax.swing.JLabel login_text;
    private javax.swing.JLabel made_with_love;
    public javax.swing.JLabel minimizedIcon;
    private javax.swing.JLabel passwordIcon;
    private javax.swing.JPanel passwordPanel;
    private javax.swing.JPasswordField passwordTextField;
    private javax.swing.JSeparator separator;
    private javax.swing.JLabel title_text;
    private javax.swing.JLabel usernameIcon;
    private javax.swing.JPanel usernamePanel;
    private javax.swing.JTextField usernameTextField;
    private javax.swing.JLabel version_text;
    // End of variables declaration//GEN-END:variables
    // </editor-fold>
}
