/*
 * The MIT License
 *
 * Copyright 2020 Universitas Teknologi Yogyakarta.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package arsip.surat.view;

import arsip.surat.util.DragWindowUtil;
import java.awt.Desktop;
import java.awt.Frame;
import javax.swing.ImageIcon;
import java.awt.Image;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Muhammad Rosyid Izzulkhaq (rsdiz)
 */
public class AboutDeveloperView extends javax.swing.JFrame {

    private static AboutDeveloperView aboutDeveloperView;
    private final String URI_TO_GITHUB = "https://github.com/rsdiz/Aplikasi-E-Arsip-Surat-Menggunakan-Java-Swing";
    
    /**
     * Creates new form AboutDeveloperView
     */
    private AboutDeveloperView() {
        initComponents();
        new DragWindowUtil().enable(AboutDeveloperView.this);
    }
    
    /**
     * <editor-fold defaultstate="collapsed" desc="Singleton pattern">
     * @return instance of AboutDeveloperView
     */
    public static AboutDeveloperView getInstance() {
        if (aboutDeveloperView == null) {
            aboutDeveloperView = new AboutDeveloperView();
        }
        return aboutDeveloperView;
    } // </editor-fold>

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        basePanel = new javax.swing.JPanel();
        customTitleBar = new javax.swing.JPanel();
        title_text = new javax.swing.JLabel();
        minimizedIcon = new javax.swing.JLabel();
        exitIcon = new javax.swing.JLabel();
        contentPanel = new javax.swing.JPanel();
        infoAboutDeveloper = new javax.swing.JLabel();
        logoUty = new javax.swing.JLabel();
        bottomSeparator = new javax.swing.JSeparator();
        labelPutri = new javax.swing.JLabel();
        labelRosyid = new javax.swing.JLabel();
        labelMail = new javax.swing.JLabel();
        labelElvina = new javax.swing.JLabel();
        namaPutri = new javax.swing.JLabel();
        namaElvina = new javax.swing.JLabel();
        namaTaufik = new javax.swing.JLabel();
        namaRosyid = new javax.swing.JLabel();
        topSeparator = new javax.swing.JSeparator();
        btnForkOnGithub = new javax.swing.JButton();
        licenseText = new javax.swing.JLabel();
        btnKembali = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("About Developer");
        setLocationByPlatform(true);
        setName("about-developer"); // NOI18N
        setUndecorated(true);
        setPreferredSize(new java.awt.Dimension(600, 600));
        setResizable(false);
        setType(java.awt.Window.Type.POPUP);

        basePanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        basePanel.setPreferredSize(new java.awt.Dimension(600, 600));
        basePanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        customTitleBar.setBackground(new java.awt.Color(242, 242, 242));
        customTitleBar.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        title_text.setFont(new java.awt.Font("monogram", 0, 28)); // NOI18N
        title_text.setForeground(new java.awt.Color(20, 20, 20));
        title_text.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        title_text.setText("About Developer");
        customTitleBar.add(title_text, new org.netbeans.lib.awtextra.AbsoluteConstraints(110, 0, 360, 50));

        minimizedIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized~1.png"))); // NOI18N
        minimizedIcon.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                minimizedIconMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                minimizedIconMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                minimizedIconMouseExited(evt);
            }
        });
        customTitleBar.add(minimizedIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(520, 0, 30, 50));

        exitIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close~1.png"))); // NOI18N
        exitIcon.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exitIconMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                exitIconMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                exitIconMouseExited(evt);
            }
        });
        customTitleBar.add(exitIcon, new org.netbeans.lib.awtextra.AbsoluteConstraints(550, 0, 30, 50));

        basePanel.add(customTitleBar, new org.netbeans.lib.awtextra.AbsoluteConstraints(5, 5, 590, 50));

        contentPanel.setBackground(new java.awt.Color(230, 230, 230));
        contentPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                contentPanelMouseClicked(evt);
            }
        });
        contentPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        infoAboutDeveloper.setFont(new java.awt.Font("monogram", 0, 20)); // NOI18N
        infoAboutDeveloper.setForeground(new java.awt.Color(20, 20, 20));
        infoAboutDeveloper.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoAboutDeveloper.setText("<html><center>\nPengembang merupakan Mahasiswa Prodi Informatika Angkatan 2018<br>\nUniversitas Teknologi Yogyakarta\n</center></html>");
        contentPanel.add(infoAboutDeveloper, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 140, 570, -1));

        logoUty.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        logoUty.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/logo.png"))); // NOI18N
        contentPanel.add(logoUty, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 30, 570, -1));
        contentPanel.add(bottomSeparator, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 390, 550, 10));

        ImageIcon imagePutri = new ImageIcon(getClass().getResource("/arsip/surat/assets/images/putri.png"));
        Image image4 = imagePutri.getImage().getScaledInstance(120, 120, Image.SCALE_SMOOTH);
        labelPutri.setIcon(new javax.swing.ImageIcon(image4));
        labelPutri.setPreferredSize(new java.awt.Dimension(120, 120));
        contentPanel.add(labelPutri, new org.netbeans.lib.awtextra.AbsoluteConstraints(450, 220, -1, -1));

        ImageIcon imageRosyid = new ImageIcon(getClass().getResource("/arsip/surat/assets/images/rosyid.png"));
        Image image3 = imageRosyid.getImage().getScaledInstance(120, 120, Image.SCALE_SMOOTH);
        labelRosyid.setIcon(new javax.swing.ImageIcon(image3));
        labelRosyid.setPreferredSize(new java.awt.Dimension(120, 120));
        contentPanel.add(labelRosyid, new org.netbeans.lib.awtextra.AbsoluteConstraints(305, 220, -1, -1));

        ImageIcon imageMail = new ImageIcon(getClass().getResource("/arsip/surat/assets/images/mail.png"));
        Image image2 = imageMail.getImage().getScaledInstance(120, 120, Image.SCALE_SMOOTH);
        labelMail.setIcon(new javax.swing.ImageIcon(image2));
        labelMail.setPreferredSize(new java.awt.Dimension(120, 120));
        contentPanel.add(labelMail, new org.netbeans.lib.awtextra.AbsoluteConstraints(165, 220, -1, -1));

        ImageIcon imageElvina = new ImageIcon(getClass().getResource("/arsip/surat/assets/images/elvina.png"));
        Image image1 = imageElvina.getImage().getScaledInstance(120, 120, Image.SCALE_SMOOTH);
        labelElvina.setIcon(new javax.swing.ImageIcon(image1));
        labelElvina.setPreferredSize(new java.awt.Dimension(120, 120));
        contentPanel.add(labelElvina, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 220, -1, -1));

        namaPutri.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        namaPutri.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        namaPutri.setText("Putri");
        contentPanel.add(namaPutri, new org.netbeans.lib.awtextra.AbsoluteConstraints(450, 350, 120, -1));

        namaElvina.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        namaElvina.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        namaElvina.setText("Elvina");
        contentPanel.add(namaElvina, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 350, 120, -1));

        namaTaufik.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        namaTaufik.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        namaTaufik.setText("Taufik");
        contentPanel.add(namaTaufik, new org.netbeans.lib.awtextra.AbsoluteConstraints(165, 350, 120, -1));

        namaRosyid.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        namaRosyid.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        namaRosyid.setText("Rosyid");
        contentPanel.add(namaRosyid, new org.netbeans.lib.awtextra.AbsoluteConstraints(305, 350, 120, -1));
        contentPanel.add(topSeparator, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 200, 550, 10));

        btnForkOnGithub.setBackground(new java.awt.Color(242, 242, 242));
        btnForkOnGithub.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        btnForkOnGithub.setForeground(new java.awt.Color(102, 102, 102));
        btnForkOnGithub.setText("FORK ON GITHUB");
        btnForkOnGithub.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnForkOnGithubActionPerformed(evt);
            }
        });
        contentPanel.add(btnForkOnGithub, new org.netbeans.lib.awtextra.AbsoluteConstraints(400, 480, 170, 40));

        licenseText.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        licenseText.setForeground(new java.awt.Color(100, 100, 100));
        licenseText.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        licenseText.setText("Sistem ini dikelola dan merujuk pada lisensi MIT");
        contentPanel.add(licenseText, new org.netbeans.lib.awtextra.AbsoluteConstraints(22, 409, 550, 40));

        btnKembali.setBackground(new java.awt.Color(242, 242, 242));
        btnKembali.setFont(new java.awt.Font("monogram", 0, 24)); // NOI18N
        btnKembali.setForeground(new java.awt.Color(255, 51, 51));
        btnKembali.setText("KEMBALI");
        btnKembali.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnKembaliActionPerformed(evt);
            }
        });
        contentPanel.add(btnKembali, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 480, 170, 40));

        basePanel.add(contentPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(5, 55, 590, 540));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(basePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(basePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        getAccessibleContext().setAccessibleName("about-developer");
        getAccessibleContext().setAccessibleDescription("");
        getAccessibleContext().setAccessibleParent(basePanel);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void minimizedIconMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseClicked
        this.setState(Frame.ICONIFIED);
    }//GEN-LAST:event_minimizedIconMouseClicked

    private void minimizedIconMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseEntered
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized-hover~1.png")));
    }//GEN-LAST:event_minimizedIconMouseEntered

    private void minimizedIconMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_minimizedIconMouseExited
        minimizedIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/minimized~1.png")));
    }//GEN-LAST:event_minimizedIconMouseExited

    private void exitIconMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseClicked
        this.dispose();
        LoginView.getInstance().setState(Frame.NORMAL);
        LoginView.getInstance().setVisible(true);
    }//GEN-LAST:event_exitIconMouseClicked

    private void exitIconMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseEntered
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close-hover~1.png")));
    }//GEN-LAST:event_exitIconMouseEntered

    private void exitIconMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitIconMouseExited
        exitIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arsip/surat/assets/images/close~1.png")));
    }//GEN-LAST:event_exitIconMouseExited

    private void contentPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_contentPanelMouseClicked
        // DO NOTHING
    }//GEN-LAST:event_contentPanelMouseClicked

    private void btnKembaliActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnKembaliActionPerformed
        exitIconMouseClicked(null);
    }//GEN-LAST:event_btnKembaliActionPerformed

    /**
     * <editor-fold defaultstate="collapsed" desc="Fungsi untuk membuka link dibrowser">
     * @param evt 
     */
    private void btnForkOnGithubActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnForkOnGithubActionPerformed
        Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(URI_TO_GITHUB));
            } catch (IOException ex) {
                Logger.getLogger(AboutDeveloperView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_btnForkOnGithubActionPerformed
    // </editor-fold>
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(AboutDeveloperView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            new AboutDeveloperView().setVisible(true);
        });
    }
    
    // <editor-fold defaultstate="collapsed" desc="Deklarasi Variable">
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel basePanel;
    private javax.swing.JSeparator bottomSeparator;
    private javax.swing.JButton btnForkOnGithub;
    private javax.swing.JButton btnKembali;
    private javax.swing.JPanel contentPanel;
    private javax.swing.JPanel customTitleBar;
    private javax.swing.JLabel exitIcon;
    private javax.swing.JLabel infoAboutDeveloper;
    private javax.swing.JLabel labelElvina;
    private javax.swing.JLabel labelMail;
    private javax.swing.JLabel labelPutri;
    private javax.swing.JLabel labelRosyid;
    private javax.swing.JLabel licenseText;
    private javax.swing.JLabel logoUty;
    private javax.swing.JLabel minimizedIcon;
    private javax.swing.JLabel namaElvina;
    private javax.swing.JLabel namaPutri;
    private javax.swing.JLabel namaRosyid;
    private javax.swing.JLabel namaTaufik;
    private javax.swing.JLabel title_text;
    private javax.swing.JSeparator topSeparator;
    // End of variables declaration//GEN-END:variables
// </editor-fold>
}