/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageObjectFactory
implements ModuleFactory {
    private static final Log LOG = LogFactory.getLog(PackageObjectFactory.class);
    private static final String NULL_LOADER_MESSAGE = "moduleClassLoader must not be null";
    private static final String IGNORING_EXCEPTION_MESSAGE = "Keep looking, ignoring exception";
    private static final String UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE = "PackageObjectFactory.unableToInstantiateExceptionMessage";
    private static final String STRING_SEPARATOR = ", ";
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        this.packages = new LinkedHashSet<String>(packageNames);
        this.moduleClassLoader = moduleClassLoader;
    }

    public PackageObjectFactory(String packageName, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        this.packages = new LinkedHashSet<String>(1);
        this.packages.add(packageName);
        this.moduleClassLoader = moduleClassLoader;
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        String nameCheck;
        Object instance = this.createObjectWithIgnoringProblems(name, this.getAllPossibleNames(name));
        if (instance == null && (instance = this.createObjectWithIgnoringProblems(nameCheck = name + "Check", this.getAllPossibleNames(nameCheck))) == null) {
            String attemptedNames = PackageObjectFactory.joinPackageNamesWithClassName(name, this.packages) + STRING_SEPARATOR + nameCheck + STRING_SEPARATOR + PackageObjectFactory.joinPackageNamesWithClassName(nameCheck, this.packages);
            LocalizedMessage exceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, attemptedNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getMessage());
        }
        return instance;
    }

    private Object createObjectWithIgnoringProblems(String className, Set<String> secondAttempt) {
        Object instance = this.createObject(className);
        if (instance == null) {
            Iterator<String> ite = secondAttempt.iterator();
            while (instance == null && ite.hasNext()) {
                instance = this.createObject(ite.next());
            }
        }
        return instance;
    }

    private Set<String> getAllPossibleNames(String name) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.packages.stream().map(packageName -> packageName + name).collect(Collectors.toList()));
        return names;
    }

    private static String joinPackageNamesWithClassName(String className, Set<String> packages) {
        return packages.stream().filter(name -> name != null).collect(Collectors.joining(className + STRING_SEPARATOR, "", className));
    }

    private Object createObject(String className) {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className, true, this.moduleClassLoader);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            instance = declaredConstructor.newInstance(new Object[0]);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException exception) {
            LOG.debug(IGNORING_EXCEPTION_MESSAGE, exception);
        }
        return instance;
    }
}

