단순하게 생각해보자.

파일의 개수가 n 개라면,

모든 경우의 수를 다 따져본다고 가정해보자.

그러면 n 개 중에서 2개를 고르고... n-1 개 중에서 2개를 고르고 ... 2 개 중에서 2 개를 고르게 되겠죠..?

그러면 nC2 + n-1C2 +...+ 2C2 ~= n^3 

그리고 n 의 최댓값은 500 이니까

O(500^3) = 125,000,000 이다.

별 문제가 없다면 1.5 초 이내에 겨우겨우 동작하는 프로그램이 만들어질 수는 있겠지만..!

사실 코테에서 시간 제한이 2초이면 보통 0.2~0.5 초 내에 동작이 가능하도록 설계한다고 한다.

또 우리는, 입출력도 많이 받아야 할텐데

예상보다 더 많은 시간복잡도가 소요될 수 있으므로 보수적으로 접근하는 게 맞다.

그러니까, 완전 탐색으로 푸는 것은 조금은 위험할 수 있겠다.

그러면 어떻게 풀 수 있을까?

## ⭐ 어려운 문제는 쉬운 문제로 바꿔서 생각해보면 인사이트를 얻을 가능성이 있다..!

파일의 개수가 4 개라고 치고 각각 A,B,C,D 라고 해보자.

그러면 어떤 경우의 수가 있을까..?

1. [A B] 를 합치고, [C D] 를 합치고, [A B] 와 [C D] 를 합칠 수 있겠다.

2. [B C] 를 합치고, [A D] 를 합치고, [B C] 와 [A D] 를 합칠 수 있다.

3. [A C] 를 합치고, [B D] 를 합치고, [A C] 와 [B D] 를 합칠 수 있다.

4. [A B] 를 합치고, [A B] 와 C 를 합치고, [A B C] 와 D 를 합쳐도 되겠다.

5. [C D] 를 합치고, [C D] 와 B 를 합치고, [B C D] 와 A 를 합쳐도 된다.

...


자, 모든 경우가 다 그런거는 아니지만

특히 4 번째 경우를 보면

[A B] 를 합치는 계산을 (가) 라고 하자.

그러면 [A B] 와 C 를 합칠 때 (가) 가 이용된다. -> 얘는 (나) 라고 하자.

그러면 [A B C] 와 D 를 합칠 때 (나) 가 이용된다.

즉, 반복된 연산을 하게 되는 경우가 종종 발생한다는 것이다.

반복된 연산이 있을 때 하나하나 다 계산하는 것은 O(N^3) 의 시간복잡도를 가질 것이다.

즉, 반복된 연산을 피해야 할 텐데...

이러한 경우에 반복된 연산의 결과 값을 다른 메모리에 저장하고,

반복된 연산이 필요하면 실제로 그 연산을 반복하는 것이 아닌 메모리에서 꺼내오는 방법을 많이 사용한다.

즉, 캐싱을 하자는 것이고

이는 알고리즘에서 다이나믹프로그래밍에서 말하는 메모이제이션이다.

파일을 합칠 때, 반복된 결과 값을 메모리에 저장해서 활용하면 이 문제를 해결할 수 있을 것이라고 짐작할 수 있겠다.

---

## ⭐ 이제 규칙을 조금 더 정확하게 표현해보자.

f(p, q) 라는 함수를 정의해보자.

f(p, q) 는 p 부터 q 까지의 파일을 합칠 때의 최소 비용이다.

즉, A B C D E 일때 f(0, 2) 는 A B C D 을 합치는 데에 최소 비용을 의미한다는 것이다.

일반화해서 생각해보면

f(p, q) = f(p, p) + f(p+1, q) 이거나 f(p, p+1) + f(p+2, q) 이거나 f(p, p+2) + f(p+3, q) ...

라는 것이다.

저 경우의 수 중 가장 작은 것이 우리가 원하는 답이 될 것이다.

또한 각각을 계산할 때, 중복된 연산이 있으면 기록하여 최적화를 할 수 있을 것이다.

자, 함수 형태를 보면 2차원이다..

즉, dp 테이블을 2차원으로 선언해야 한다.

```
f(p, q) 는 dp[p][q] 
```
---

A, B, C, D 라는 비용을 가지는 파일을 가지고 있다고 생각해보자.

하나의 파일만 있으면, 합칠 수 없으므로 비용이 0 이다.

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/0d32cb3b-7fef-4fe3-bff4-97546f2ce757)

그러므로 위와 같이 대각선은 모두 0 이여야 할 것.

파일 두개를 합치는 비용은 단 하나의 경우 밖에 존재하지 않는다.

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/ffeca4c0-c300-4c3c-84c7-08a375ed3b3a)

이제 저 파란 칸을 채워야 할 텐데,

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/6468f8bb-3255-475d-837b-806981c3af04)

어떻게 해야 할까

파란칸은 A B C 를 합치는 최소 비용을 의미한다.
AB 를 먼저 합치고 C 를 합칠 수 도 있고  (AB + ABC)
BC 를 먼저 합치고 A 를 합칠 수 도 있다. (BC + ABC)

여기서 질문.

```
🔥A 와 C 를 합쳐서 AC 를 만든 다음에 B 와 합치는 경우는 왜 고려하지 않나요????
```

이래서 문제를 꼼꼼하게 읽어야 한다.. 😢
본 문제를 다시 읽어보면 아래와 같은 문장이 존재한다.
**소설의 여러 장들이 연속이 되도록 파일을 합쳐나간다**
사실 조금 모호하게 문장을 작성한 것 같긴하다. 아무래도 원본 문제가 영어로 이루어져있고, 이를 번역한 것이다 보니 조금
의미가 애매해진 것 같은데.. 원본 문제인 Merging Files ; ICPC 2015 F. 의 지문에서는 아래와 같이 서술되어있다.

```
He can only merge two files containing continuing chapters into a new intermediate file
and keep merging the original files or intermediate files until he gets one final file. 
```
원래 문장이 조금 더 직관적으로 이해되는 것 같다.

여튼, 파일을 합칠 때에는 인접한 파일들만 합칠 수 있다.
A B C D 가 있으면 A 와 D 는 합칠 수 없다..!
정렬하면 안된다!!!


노란 칸은 B C D 를 합치는 최소 비용이며
BC 를 합치고 D 를 합치거나 (BC + BCD)
CD 를 합치고 B 를 합칠 수 있다. (CD + BCD)

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/9e4cd70e-c871-499a-9936-f152903cfe62)


각 경우의 수에 대해서 최소 비용이 발생하는 경우를 택하면 된다

그러면 f(A, D) 는 ?
f(A, A) + f(B, D) 이거나
f(A, B) + f(C, D) 이거나
f(A, C) + f(D, D) 의 경우의 수가 있고, 각 경우에 대해서 가장 작은 비용을 택하면 된다.

---

첫 번째 테스트 케이스로부터 다시 이해해보자.

아래의 상태까지는 쉽게 채울 수 있다.


![image](https://github.com/Study-Anything/Algorithm/assets/96612168/a9ed2878-83a0-4b8f-bcc3-edbe82e7ad79)

이제 DP[A][C] 를 채워보자.

DP[A][C] 는 DP[A][B] + ABC 와 DP[B][C] + ABC 중 최솟값이므로 160 이다.
DP[B][D] 는 DP[B][C] + BCD 와 DP[C][D] + BCD 중 최솟값인 170 이다.

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/c28ee1aa-64a6-416f-ab78-776aa5341423)

최종 답안이 될 DP[A][D] 는?
DP[A][B] + DP[C][D] + ABCD 와
DP[A][C] + ABCD 와
DP[C][D] + ABCD 중 최솟값인 300 이다.


![image](https://github.com/Study-Anything/Algorithm/assets/96612168/2abf6a38-9a0b-489f-ad95-30e348c551af)


