## 1차원 BFS + 경로 역추적

문제를 간단히 요약하면

일차원 수직선 상에서 수빈이와 동생의 위치가 각각 N, K 로 주어진다.

이때 수빈이는 앞으로 한칸가거나 뒤로 한칸, 혹은 순간이동을 할 수 있다.

각각의 이동을 할 때마다 1 초가 걸린다고 하면

수빈이가 동생의 위치로 도달할 수 있는 최단 시간과, 최단 경로(몇 번 노드를 통해서 왔는지)를 출력해야 한다.

---

최단 시간 같은 경우에는 전형적인 BFS 문제로 해결할 수 있다.

게다가 1차원 BFS 라서, 조금 더 구현이 간단하다. (익숙하지 않을 수는 있지만)

그런데 까다로운 부분은, 최단 경로를 출력해야 한다는 것이다..

예를 들어

N 에서 K 까지의 최단 시간이 4 이라면

**몇 번 노드를 통해서 K 까지 도달했는지도**를 출력해야 한다는 것이다.

어떻게 이를 구현할 수 있을까?

이와 같은 유형을 **경로 역추적** 이라고 한다.

**경로 역추적** 은 여러 알고리즘에 결합되어 사용된다.

예를 들어 **숨바꼭질4** 문제에서 처럼 최단 경로/시간을 구할 때 사용될 수도 있고

**다이나믹 프로그래밍** 문제에서 큰 문제로 도달하기까지 최적의 작은 문제들(?)의 결과를 출력하는 문제도 나올 수 있다. 

관련하여 [좋은 블로그 포스팅](https://velog.io/@flowersayo/%EB%8F%99%EC%A0%81%EA%B3%84%ED%9A%8D%EB%B2%95-%EC%97%AD%EC%B6%94%EC%A0%81) 을 발견해서 궁금한 사람은 읽어봐도 좋을 것 같다.

---

**숨바꼭질4** 문제는 1차원 bfs 를 통한 최단거리 탐색 + 경로 역추적이다.

1차원 맵에서 진행하기 때문에, 경로 역추적을 구현하는 것은 상당히 간단하다고 할 수 있겠다.

어떤 아이디어가 필요하냐면,

old node 에서 new node 로 진행할 때

parent 배열에다가 이를 기록하면 어떨까?

즉, parent[new node] = old node 이런 식으로 말이다.

이 문제에서 수빈이는 동생에게 무조건 도달할 수 밖에 없다.

그러면

parent[k] = x 라고 하면 x 는 k 에 도달하기 바로 전 노드임을 알 수 있다.

x 노드에 도달하기 바로 직전의 노드는?

parent[x] = y 일 때, y 가 이에 해당한다.

그러면

parent[k] -> x -> parent[x] = y -> z -> ... -> n

이런 식으로 거꾸로 된 경로를 얻을 수 있을 것이다.

(*) 올바른 경로를 출력하려면 순서를 뒤집어주어야 하며, 여기서는 보통 stack 을 이용한다.

---

parent 배열을 추가적으로 선언해도 되겠지만,

visited 배열을 이용해도 된다.

그러면 조금 더 메모리 측면에서 효율적인 코드를 작성할 수 있다.

visted 배열이 (1)방문 여부 확인 , (2)경로 저장 의 2가지 기능을 모두 수행하게끔 구현해보자.

⭐ 이를 위해서 visited 의 초깃값은 어떻게 해주어야 할까?
