**기본적인 bfs 를 이용한 최단 거리 탐색 문제에 약간의 아이디어를 첨가한 문제**

---

최단경로를 탐색하는 알고리즘에 대해서 다시 remind 하고 생각해보자.

기본적으로 그래프에서 최단 경로를 구해야하는 경우

1. bfs
2. 다익스트라
3. 벨만포드
4. 플로이드-워셜

을 변형하여 사용한다. 

그래프의 형태(가중치가 양수만 있는지, 아닌지), 시간 복잡도, 구해야 하는 것(단일 노드에 대한 최단경로인지 아닌지)에 따라서 알고리즘을 선택해주면 된다.

그 중, 모든 edge 의 가중치가 1 인 경우에는 bfs 를 이용하여 최단 경로를 구할 수 있다.

주로, 한 칸 움직일 때 마다 1분이 걸린다라던가.. 이러한 문제 서술이 있는 경우에는 bfs 으로 해결이 가능하다.

---

근데 이 문제는 특별한 상황이 하나 더 추가되어있다. (그래서 골드인 듯)

```
매 분마다 고슴도치는 현재 있는 칸과 인접한 네 칸 중 하나로 이동할 수 있다. 
(위, 아래, 오른쪽, 왼쪽) 물도 매 분마다 비어있는 칸으로 확장한다. 
물이 있는 칸과 인접해있는 비어있는 칸(적어도 한 변을 공유)은 물이 차게 된다. 
물과 고슴도치는 돌을 통과할 수 없다. 또, 고슴도치는 물로 차있는 구역으로 이동할 수 없고, 
물도 비버의 소굴로 이동할 수 없다.

티떱숲의 지도가 주어졌을 때, 
고슴도치가 안전하게 비버의 굴로 이동하기 위해 필요한 최소 시간을 구하는 프로그램을 작성하시오.

고슴도치는 물이 찰 예정인 칸으로 이동할 수 없다. 
즉, 다음 시간에 물이 찰 예정인 칸으로 고슴도치는 이동할 수 없다. 이동할 수 있으면 고슴도치가 물에 빠지기 때문이다.
```

음.

고슴도치만 이동하는 게 아니라, 물도 이동한다.

더불어 고슴도치가 이동할 때, 물이 찰 예정인 칸으로는 이동을 할 수 없다는 제약이 존재한다.

이러한 상황일 때, 고슴도치가 목적지에 도달할 수 있는지.

도달할 수 있다면 최단 시간이 얼마인 지를 구해야 한다.

어떻게 풀까?



---

# Solution 1 (정해)

이렇게 하면 어떨까?

물에 대한 bfs 를 1번 수행하며, 물이 이동할 수 있는 경로와 시간을 저장한 2차원 배열을 하나 만든다.

그리고 이제 고슴도치에 대한 bfs 를 수행하는데,

물이 이동할 수 있는 경로와 시간을 저장한 2차원 배열을 참조하며

새롭게 움직일 칸이 물이 찰 예정이라면, 그 칸으로 이동하지 못하도록 조건을 걸면서 탐색하자.

그렇게 했을 때, 목적지에 도달할 수 있다면 소요 시간을 반환하고

목적지에 도달할 수 없다면 "KAKTUS" 를 출력하도록 하자.

이렇게 하면 bfs 를 2 번 수행해야 하는데,

bfs 는 연결된 모든 노드에 대해서 수행되므로,

1 회의 bfs 당 대략 O(50*50) 이기 때문에 시간 복잡도는 크게 걱정하지 않아도 되겠다. (시간제한은 1초이므로 넉~넉하다.)

정리하면, 물에 대한 bfs 를 먼저 수행한 뒤에 고슴도치에 대한 bfs 를 수행하여 이 문제를 해결할 수 있다.




---

# Solution 2: 조금 더 최적화된 풀이

만약, bfs 를 1 번만 수행하면서 이를 해결할 수는 없는지 면접관이 물어본다면..??

혹은 조건을 조금 더 까다롭게 준 경우에, 물과 고슴도치의 이동을 별개로 따지지 못하기 때문에 한 번의 bfs 내에서 해결해야 하는 경우가 발생할 수 있겠다. (골드 1~2 정도일 듯)

이러한 경우에는 어떻게 풀이할 수 있을까?

---


솔루션은 굉장히 간단하다.

bfs 를 1번 수행하는데,

물의 이동을 담당하는 Queue 와

고슴도치의 이동을 담당하는 Queue 를 하나 씩 만들자.

즉, bfs 를 수행할 때 2 개의 Queue 를 사용하겠다는 것이다.

각각의 노드에 대해서 탐색을 할 때,

먼저 물을 이동을 담당하는 Queue 가 비어있지 않다면, 큐를 비우면서 물을 이동시킨 다음에 

고슴도치 Queue 를 비우면서 탐색을 한다.

이렇게 하면 실시간으로 물의 이동과 고슴도치의 이동을 비교할 수 있다.

시간적으로도 더욱 효율적일 것이다.

왜냐면 bfs 를 2번 수행하는 경우는, 어쨌든 모든 경우의 수를 다 따져본다는 것인데

이와 같이 bfs 를 1 번 수행하는 경우에는,

조금씩 조금씩 물과 고슴도치를 이동시켜나가면서

고슴도치가 더이상 이동할 수 없으면 그냥 더이상 탐색하지 않고 바로 답을 도출할 수 있을 것이기 때문이다.

하지만 이렇게 풀이하면 코드가 조금 복잡해진다는 단점이 있다.

특정 조건을 놓쳐서 맞왜틀 하게 될 여지가 상당히 높다.

그래도.. 어렵지는 않기 때문에 한 번 해보는 것도 좋을 것 같다.

(정해는 bfs 를 2번 사용하는 풀이인 것 같다. )
