## ✏️ [구간합 구하기 5](https://www.acmicpc.net/problem/11660)


2 차원 정수 테이블에서 시작 좌표와 끝 좌표가 주어지면 하나의 영역이 만들어지고,
해당 영역 내의 원소들의 합을 반환한다.

위의 행위를 하나의 쿼리를 수행한다고 정의하자.

그리고 살펴봐야 하는 것은 테이블의 크기는 최대 1024 x 1024 라는 것이다.

그리고 쿼리의 개수는 최대 100,000 개이다.

일반적으로 2차원 영역 내 합을 구하는 것은 2중 루프로 계산할 수 있다.

최악의 경우를 생각해보자.

그러면 시작 좌표가 (1, 1) 이고 끝 좌표가 (n, n) 으로 주어지는 쿼리를 M 번 수행해야 한다.

쿼리 1번을 수행하기 위해서 2중 루프를 순회해야 하므로 O(N^2) 만큼 소요되는데, 이를 M 번 해야 하므로

시간 복잡도는 O(MN^2) 임을 알 수 있다.

N 의 최대는 1024 이고 M 의 최대는 100,000 이므로

100,000 X 1024 ^2 = 104,857,600,000 ~= 1000 억이고, 이 문제의 시간 제한은 1초이므로 절대로 절대로 통과하지 못하는 것을 알 수 있다.

어떻게 타임컷팅을 할 수 있을까??

---

생각해보면 영역 내의 합을 구하는 과정에서 불필요한 반복적인 연산이 발생하는 것이 문제다.

불필요하게 연산을 반복하지 않도록

look-up table 을 만들면 구간합을 구하는 쿼리를 O(1) 에 해결이 가능하다. ⭐

---
**(참고)**
이 문제와는 상관없지만 만약 2차원 테이블을 수정하는 쿼리가 포함되는 경우에는, 어떻게 효율적으로 풀 수 있을까?

예를들어 이 문제에서는 초기에 입력받은 2차원 배열이 변하지 않지만

UPDATE 라는 쿼리가 존재한다고 치고,

이를 수행하면 특정 영역 내의 원소들이 수정된다.

그러면 기존에 만들어 놓은 Look-up table 이 소용이 없어질텐데...

이와 같이 실시간으로 수정될 수 있는 원소들에 대한 구간합을 구하는 문제는 어떻게 효율적으로 해결할 수 있을까?

-> 이는 세그먼트 트리라는 자료구조를 통해 해결이 가능하다.



