# 정수 삼각형
문제 설명

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/477add48-8852-45b6-863d-dede996b2b9a)

```
위와 같은 삼각형의 꼭대기에서 바닥까지 이어지는 경로 중, 거쳐간 숫자의 합이 가장 큰 경우를 찾아보려고 합니다. 아래 칸으로 이동할 때는 대각선 방향으로 한 칸 오른쪽 또는 왼쪽으로만 이동 가능합니다. 예를 들어 3에서는 그 아래칸의 8 또는 1로만 이동이 가능합니다.

삼각형의 정보가 담긴 배열 triangle이 매개변수로 주어질 때, 거쳐간 숫자의 최댓값을 return 하도록 solution 함수를 완성하세요.

제한사항
삼각형의 높이는 1 이상 500 이하입니다.
삼각형을 이루고 있는 숫자는 0 이상 9,999 이하의 정수입니다.
입출력 예
triangle	result
[[7], [3, 8], [8, 1, 0], [2, 7, 4, 4], [4, 5, 2, 6, 5]]	30
```

차근차근 생각해보자.

7
3 8
8 1 0
2 7 4 4
4 5 2 6 5

dp[501][501];
dp[x][y] : (x, y) 까지 합의 최댓값

dp[0][0] = 7 (tri[0][0])

dp[0][1] = tri[0][1] + tri[0][0] = 10
dp[1][1] = tri[1][1] + tri[0][0] = 15

dp[0][2] = tri[0][2] + dp[0][1] // 끝 지점
// 중간지점이면
dp[1][2] = tri[1][2] + max(dp[x-1][y-1], dp[x][y-1])
dp[2][2] = tri[2][2] + dp[2][2] // 끝지점

dp[2][3] = tri[2][3] + max(dp[1][2], dp[2][2])

dp[x][y] = tri[x][y] + max(dp[x][y-1], dp[x+1][y-1])

정리하면,

중간 지점에 해당하면
dp[x][y] = tri[x][y] + max(dp[x-1][y-1], dp[x][y-1])

왼쪽 끝 지점에 해당하면,
dp[x][y] = tri[x][y] + dp[x][y-1]

오른쪽 끝 지점에 해당하면,
dp[x][y] = tri[x][y] + dp[x-1][y-1]

그러면 초기화 작업을 먼저하면,

dp[0][0] = tri[0][0] 만 해주면 됨

최대값은 4,999,500 이므로 dp table 은 integer 으로 선언

dp table 을 갱신할 때 마다 최댓값을 갱신하도록 하자.

DP 문제는 보통 top-down(재귀) 방법과 bottom-up (loop) 방법으로 구현할 수 있다.

위 문제의 경우에도 두 방법으로 구현이 가능하므로 둘 다 해보면 좋을 것 같다.

정수 삼각형 문제는 바텀업이 조금 더 간편하긴 하다.

탑다운으로 구현할 때에는 스택 오버플로우를 조심하자..
