# 입국심사 힌트

이런 유형의 문제는 이분 탐색을 까먹으면, 접근조차 하기 어렵다...😢

이분 탐색을 응용한 대표적인 문제 유형으로, 이번 기회에 잘 알아두자.

사실 할때마다 헷갈리는 유형이다.. (off by one error 가 가장 많이 발생함)

---

자, 문제 상황은 단순하다.

times 배열과 n 이 주어지면, 최소로 입국심사를 완료할 수 있는 시간을 반환해야 한다.

반대로 생각해보자.

만약 t 라는 시간이 주어진다면, n 명을 전부 다 입국심사를 시킬 수 있을까?

음..

각각의 심사관은 병렬적으로 입국심사를 수행한다.

그러므로, times 배열을 1번 순회하는 것만으로 입국심사가 가능한 총 인원을 알 수 있다.

```
for(int i = 0 ; i < times.length; i ++){
     cnt += t/times[i];
}
```

위 for 루프를 빠져나왔을 때 cnt 는 n 보다 작을수도, 같을수도, 클수도 있다.

작다면, t 를 늘려야 할 것이고

같거나 크다면 t 가 정답일지도 모르지만, 더 찾아봐야 한다(?) - 왜냐면 최적이 아닐수도있음.

근데 문제는 주어진 변수들의 크기가 상당히 크다.

심사관의 심사 시간은 최대 10 억분이다.. 대체 ..

t 를 단순히 순차적으로 탐색하면,

t 는 1 ~ 10억 * n 사이의 범위 내에 존재하므로

절대로 시간 내에 해결하지 못할 것이다.

그러면, 보다 효율적으로 탐색해야 한다.

이럴 때 쓰는 게, 이분 탐색이다.

t 의 최솟값은 대충 0 이고 (엄밀하게는 times 배열의 최솟값 * n 일 듯)
최댓값은 times 배열의 최댓값 * n 이다.

t 의 범위를 이분탐색으로 좁혀나가며,

최소의 t 를 찾으면 된다.

이분 탐색은 O(logN) 만큼의 시간 복잡도를 가진다. 여기서 N 은 최대 10억 * 10 만 = 10^14 이 된다.

근데 여기서 각각의 step 마다 우리는 t 라는 시간이 주어졌을 때 몇 명이 입국심사를 통과할 수 있는 지 검색해야 하고, 이는 times 배열을 1 회 순회하여 구할 수 있으므로

최종적인 시간 복잡도는 

O(MlogN) 이다.  // N 은 times.length

그러므로 시간 내에 동작할 것이다.

---

이제 이분 탐색 코드를 작성해야 하는데,

이런 유형은 한 조건을 잘못 설정해서 틀리는 경우가 정말 많다. 풀 때마다 헷갈린다.

이럴 때는 범위가 변화하는 것을 출력해보면서

조건을 수정해나가며 완성시킨다는 느낌으로 코드를 작성하면 된다.

물론, 한 번에 해결하면 좋지만 워낙 헷갈리니까 😢
