# 사이클 게임 Solution
(https://www.acmicpc.net/problem/20040)

작성일: 2023. 05. 03. 수

작성자: 이재현

---

```
문제
사이클 게임은 두 명의 플레이어가 차례대로 돌아가며 진행하는 게임으로, 선 플레이어가 홀수 번째 차례를, 
후 플레이어가 짝수 번째 차례를 진행한다. 게임 시작 시 0 부터 n − 1 까지 고유한 번호가 부여된 평면 상의 점
n 개가 주어지며, 이 중 어느 세 점도 일직선 위에 놓이지 않는다. 매 차례 마다 플레이어는 두 점을 선택해서
이를 연결하는 선분을 긋는데, 이전에 그린 선분을 다시 그을 수는 없지만 이미 그린 다른 선분과 교차하는 것은 가능하다.
게임을 진행하다가 처음으로 사이클을 완성하는 순간 게임이 종료된다. 사이클 C는 플레이어가 그린 선분들의 부분집합으로, 
다음 조건을 만족한다.

C에 속한 임의의 선분의 한 끝점에서 출발하여 모든 선분을 한 번씩만 지나서 출발점으로 되돌아올 수 있다.

문제는 선분을 여러 개 그리다 보면 사이클이 완성 되었는지의 여부를 판단하기 어려워 
이미 사이클이 완성되었음에도 불구하고 게임을 계속 진행하게 될 수 있다는 것이다. 
이 문제를 해결하기 위해서 게임의 진행 상황이 주어지면 몇 번째 차례에서 사이클이 완성되었는지,
혹은 아직 게임이 진행 중인지를 판단하는 프로그램을 작성하려 한다.

입력으로 점의 개수 n과 m 번째 차례까지의 게임 진행 상황이 주어지면 사이클이 완성 되었는지를 판단하고,
완성되었다면 몇 번째 차례에서 처음으로 사이클이 완성된 것인지를 출력하는 프로그램을 작성하시오.

입력
입력은 표준입력을 사용한다. 입력의 첫 번째 줄에는 점의 개수를 나타내는 
정수 3 ≤ n ≤ 500,000 과 진행된 차례의 수를 나타내는 정수 3 ≤ m ≤ 1,000,000 이 주어진다. 
게임에서 사용하는 n개의 점에는 0 부터 n − 1 까지 고유한 번호가 부여되어 있으며, 
이 중 어느 세 점도 일직선 위에 놓이지 않는다. 
이어지는 m 개의 입력 줄에는 각각 i번째 차례에 해당 플레이어가 선택한 두 점의 번호가 주어진다 (1 ≤ i ≤ m).

출력
출력은 표준출력을 사용한다. 입력으로 주어진 케이스에 대해,
m 번째 차례까지 게임을 진행한 상황에서 이미 게임이 종료되었다면 사이클이 처음으로 만들어진
차례의 번호를 양의 정수로 출력하고, m 번의 차례를 모두 처리한 이후에도 종료되지 않았다면 0을 출력한다.
```

---

유니온 파인드를 알고 있다면 매우 매우 쉬운 문제.

문제를 간단하게 요약하면,

N 명의 선수가 선분을 m 차례 번갈아가면서 그리는데

도중에 사이클이 발생한다면, 몇 번째에 사이클이 발생했는지 출력하고

사이클이 발생하지 않는다면 0 을 출력하면 된다.

선분을 그린다는 것은 두 개의 원소를 하나의 부분 집합으로 만든다는 의미이다.

즉, union

사이클이 발생하는지 여부는

i 번째 차례에서 a-b 를 이어 선분을 그린다고 가정하면

a 와 b 의 parent 가 동일한 지 체크해주면 된다.

아래 그림을 보면 조금 더 이해가 쉬울 것 같다.

![image](https://user-images.githubusercontent.com/96612168/235882446-f30aab88-11bc-4c75-90d3-1a11c80f31cc.png)

이번에는 사이클이 생기는 경우에 대한 그림이다.

![image](https://user-images.githubusercontent.com/96612168/235882487-a9ac05f7-37c9-402e-a512-5215d6a180eb.png)

유니온 파인드를 구현할 수 있는지 아닌지를 물어보는 아주 기본적인 문제이다!

보통 유니온 파인드 알고리즘이 메인으로 나오지는 않고,

다른 알고리즘에 섞여서 나오거나

유니온 파인드 연산을 조금 독특하게 변형해서 풀어야하게끔 출제되는 것 같다.

이 문제를 통해 유니온 파인드에 대해서 익혀보고,

가져올 유니온 파인드를 변형해서 사용해야 하는 어려운 문제를 같이 풀어보도록 하자 🔥





