# 타겟넘버 Solution
작성일 2023. 04. 24. 월
(https://school.programmers.co.kr/learn/courses/30/lessons/43165?language=java)

```
문제 설명
n개의 음이 아닌 정수들이 있습니다. 이 정수들을 순서를 바꾸지 않고 적절히 더하거나 빼서 타겟 넘버를 만들려고 합니다. 예를 들어 [1, 1, 1, 1, 1]로 숫자 3을 만들려면 다음 다섯 방법을 쓸 수 있습니다.

-1+1+1+1+1 = 3
+1-1+1+1+1 = 3
+1+1-1+1+1 = 3
+1+1+1-1+1 = 3
+1+1+1+1-1 = 3
사용할 수 있는 숫자가 담긴 배열 numbers, 타겟 넘버 target이 매개변수로 주어질 때 숫자를 적절히 더하고 빼서 타겟 넘버를 만드는 방법의 수를 return 하도록 solution 함수를 작성해주세요.

제한사항
주어지는 숫자의 개수는 2개 이상 20개 이하입니다.
각 숫자는 1 이상 50 이하인 자연수입니다.
타겟 넘버는 1 이상 1000 이하인 자연수입니다.
입출력 예
numbers	target	return
[1, 1, 1, 1, 1]	3	5
[4, 1, 2, 1]	4	2
입출력 예 설명
입출력 예 #1

문제 예시와 같습니다.

입출력 예 #2

+4+1-2+1 = 4
+4-1+2-1 = 4
총 2가지 방법이 있으므로, 2를 return 합니다.
```

20 개 이하의 정수로 구성된 배열이 주어졌을 때

각각을 더하거나 빼서 타겟넘버를 만들 수 있는 경우의 수를 카운팅해야 한다.

직관적으로 생각해보면

숫자 카드 사이에 + 혹은 - 카드를 임의로 집어 넣었을 때 그 결과가 타겟 넘버가 되는 경우를 찾는 것과 같다.

가장 쉬운 방법은 아무래도 모든 경우의 수를 다 해보면서 카운팅하면 된다.

배열의 가장 앞에서 부터 차례대로 +, - 숫자 카드를 붙여나간다고 생각해보자.

그러면 경우의 수가 마치 트리 형태로 나오는 것을 확인할 수 있고

더 나아가, 각 원소마다 2 개의 분기점이 존재하며(더할지 뺼지)

모든 경우의 수를 다 확인해본다고 하면 O(2^n) 의 시간이 걸릴 것이고

n 의 최대는 20 이므로

2^20 = 1,048,576 밖에 되지 않아, 시간 초과가 발생하지 않을 것 임을 예상할 수 있다.

아까 설명했듯이,

경우의 수를 그려보면 트리 형태로 나오는 것을 알 수 있다.

(더 나아가 각각의 노드는 자식이 2개만 가지므로 이진 트리 형태)

타겟 넘버와 같은지 아닌지는 리프 노드까지 탐색해야 하는데,

이는 어떻게 코드로 작성할 수 있을까?

트리/그래프 구조에서 루트부터 리프까지 깊게 깊게 탐색해야 하므로 dfs 를 사용해야 한다고 떠올릴 수 있을 것이다.

재귀적으로 루트 -> 리프까지 도달하는 dfs 함수를 설계하여 위 문제를 O(2^N)에 해결할 수 있다.

---

각 노드마다 더할지 뺄지, 2 개의 분기점이 존재하는데 이는 어떻게 구현할까?

생각보다 간단하다.

flag 라는 boolean 변수를 두어,

true 이면 해당 노드를 더하고

false 이면 해당 노드를 빼주는 식으로 구현하면 된다.

이제 아래와 같이 dfs 를 구현할 수 있다.

```
void dfs(..., present sum, depth, flag){
    if(flag == true) {
      present sum 에 현재 노드를 plus
      }
    if(flag == false) {
      present sum 에 현재 노드를 minus
      }
    if(리프노드까지 도달하지 못했다면?){
       // 더 깊게 나아가야 함.
       dfs(..., depth+1, true); // 다음 노드를 더하거나
       dfs(..., depth+1, false); // 다음 노드를 빼거나
    } else if (리프 노드에 도달했는데 present sum 이 target sum 이랑 같다면?){
      카운팅.
    }
    
```
