# 카펫 Solution
(https://school.programmers.co.kr/learn/courses/30/lessons/42842?language=java)

작성일: 2023. 04. 24. 월.

**tag : 완전탐색, 투포인터, 수학**


**문제 설명**
```
Leo는 카펫을 사러 갔다가 아래 그림과 같이 중앙에는 노란색으로 칠해져 있고 테두리 1줄은 갈색으로 칠해져 있는 격자 모양 카펫을 봤습니다.

Leo는 집으로 돌아와서 아까 본 카펫의 노란색과 갈색으로 색칠된 격자의 개수는 기억했지만, 전체 카펫의 크기는 기억하지 못했습니다.

Leo가 본 카펫에서 갈색 격자의 수 brown, 노란색 격자의 수 yellow가 매개변수로 주어질 때 카펫의 가로, 세로 크기를 순서대로 배열에 담아 return 하도록 solution 함수를 작성해주세요.

제한사항
갈색 격자의 수 brown은 8 이상 5,000 이하인 자연수입니다.
노란색 격자의 수 yellow는 1 이상 2,000,000 이하인 자연수입니다.
카펫의 가로 길이는 세로 길이와 같거나, 세로 길이보다 깁니다.

입출력 예

brown	yellow	return
10	2	[4, 3]
8	1	[3, 3]
24	24	[8, 6]
```
**Solution**

문제 설명에 따르면 카펫은 갈색 조각이 노란색 조각들을 둘러싼 형태의 사각형이다.

갈색 조각과 노란색 조각의 개수가 주어지면 카펫의 가로, 세로 크기를 알아내야 한다.

갈색 조각의 개수를 brown, 노란색 조각의 개수를 yellow 라고 하자.

각각의 조각들은 정사각형이기 때문에, 개수를 면적으로 생각해도 된다.

그러면 카펫의 전체 면적은 brown + yellow 일 것이다.

가로 길이를 x 라고 하고, 세로 길이를 y 라고 하자.

그러면 아래와 같이 조건을 작성할 수 있다.

```
x * y = brown + yellow
```

우리는 x 와 y 를 알아내야 하는데 둘의 곱은 이미 알고 있고

x 와 y 는 자연수이다.

x 와 y 가 될 수 있는 후보는 x*y 의 약수들이고,

임의의 큰 자연수 N 의 약수를 구하는 방법은 O(N) 으로 가능한데,

x*y <= 2005000 이므로 여유롭다.

그러므로,

x*y 의 약수들 중에서 x 와 y 가 될 수 있는 후보를 추려내자.

이를 위해서는 한 가지 조건이 더 필요하다.

우리가 아직 사용하지 않은 조건은 갈색 조각이 노란색 조각들을 둘러싸고 있다는 것이다.

그림을 그리며 생각해보면,

카펫은 사각형이고 노란색은 항상 중심에 위치하므로

(x-2)(y-2) = yellow 라는 관계식을 하나 떠올릴 수 있다.

이제 해야할 일은 아래와 같이 축소되었다.

```
x*y 의 약수를 담은 배열에 대하여

(x-2)(y-2) = yellow 를 만족하는 x, y 를 찾자.
```

list 의 길이를 정확히는 모르겠지만, 최대 x*y <= 2005000 이라는 것은 자명하다.

그러면 O(nlogn) 이내의 방법으로 이를 구현하면 된다.

여기서부터는 풀이가 갈릴 것 같은데,

가장 괜찮아보이는 방법은 투 포인터를 사용해서 O(N) 으로 해결하는 것이다.

약수를 담은 list 배열을 구할 때,

작은 약수 부터 list 에 add 하면 list 는 오름차순 정렬된 형태로 생성될 것이다.

그리고 이 list 에 대하여 투포인터 알고리즘을 적용하여 탐색하면서

(x-2)(y-2) = yellow 를 만족하면 탈출하고 정답을 반환하면 된다!

---
조금 더 자세하게 설명하면,

list 의 왼쪽 원소를 가리키는 인덱스 변수 left = 0 
list 의 오른쪽 원소를 가리키는 인덱스 변수 right = list.size()-1 으로 초기화 한 뒤, 아래와 같은 수도 코드대로 동작시키면 된다.

```
while(left <= right){
    mul = (leftVal-2)*(rightVal-2)
    if(mul==yellow){ // (x-2)(y-2)=yellow
       정답은 {rightVal, leftVal} 이다.
       break;
    } else if(mul<yellow){
      left++; 
    } else {
      right--;
    }
}
```



---
## 조금 더 최적화하기.

약수를 구할 때, i=2 부터 xy 까지 탐색하며 찾는 방법이 가장 먼저 떠오른다.

그런데, 굳이 xy 까지 탐색해야 할까?

예를 들어

xy = 48 이고 i 가 2  라면

2 만 add 하는 것이 아니라 2 와 48/2=24 를 add 하도록 하면

root(xy) 까지만 탐색해도 된다.
