package algorithms;

import java.util.ArrayList;


/**
 * Each new term in the Fibonacci sequence is generated by adding the previous two terms. By starting with 
 * 1 and 2, the first 10 terms will be: 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, ...
 * By considering the terms in the Fibonacci sequence whose values do not exceed four million, 
 * find the sum of the even-valued terms.
 * 
 * @author joeytawadrous
 */
public class EvenFibonacciNumbers 
{
	private static ArrayList<Integer> numbers = new ArrayList<Integer>();

	public static void main (String[] args)
	{
		System.out.print(calc());
	}
	
	private static int calc()
	{
		int total = 0;

		numbers.add(1);
		numbers.add(2);
		
		fib(1, 2);
		
		for(int number : numbers)
		{
			if(number % 2 == 0)
			{
				total += number;
			}
		}
		return total;
	}
	
	private static void fib(int f1, int f2)
	{
		int fib = f1 + f2;
		//System.out.println(fib);
		
		if(fib < 4000000)
		{
			numbers.add(fib);
			
			fib(f2, fib);
		}
	}
}
