/*
 * Decompiled with CFR 0.152.
 */
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Flight
extends FlightDistance {
    private final String flightSchedule;
    private final String flightNumber;
    private final String fromWhichCity;
    private final String gate;
    private final String toWhichCity;
    private double distanceInMiles;
    private double distanceInKm;
    private String flightTime;
    private int numOfSeatsInTheFlight;
    private List<Customer> listOfRegisteredCustomersInAFlight;
    private int customerIndex;
    private static int nextFlightDay = 0;
    private static final List<Flight> flightList = new ArrayList<Flight>();

    Flight() {
        this.flightSchedule = null;
        this.flightNumber = null;
        this.numOfSeatsInTheFlight = 0;
        this.toWhichCity = null;
        this.fromWhichCity = null;
        this.gate = null;
    }

    Flight(String flightSchedule, String flightNumber, int numOfSeatsInTheFlight, String[][] chosenDestinations, String[] distanceBetweenTheCities, String gate) {
        this.flightSchedule = flightSchedule;
        this.flightNumber = flightNumber;
        this.numOfSeatsInTheFlight = numOfSeatsInTheFlight;
        this.fromWhichCity = chosenDestinations[0][0];
        this.toWhichCity = chosenDestinations[1][0];
        this.distanceInMiles = Double.parseDouble(distanceBetweenTheCities[0]);
        this.distanceInKm = Double.parseDouble(distanceBetweenTheCities[1]);
        this.flightTime = this.calculateFlightTime(this.distanceInMiles);
        this.listOfRegisteredCustomersInAFlight = new ArrayList<Customer>();
        this.gate = gate;
    }

    public void flightScheduler() {
        int numOfFlights = 15;
        RandomGenerator r1 = new RandomGenerator();
        for (int i = 0; i < numOfFlights; ++i) {
            String[][] chosenDestinations = r1.randomDestinations();
            String[] distanceBetweenTheCities = this.calculateDistance(Double.parseDouble(chosenDestinations[0][1]), Double.parseDouble(chosenDestinations[0][2]), Double.parseDouble(chosenDestinations[1][1]), Double.parseDouble(chosenDestinations[1][2]));
            String flightSchedule = this.createNewFlightsAndTime();
            String flightNumber = r1.randomFlightNumbGen(2, 1).toUpperCase();
            int numOfSeatsInTheFlight = r1.randomNumOfSeats();
            String gate = r1.randomFlightNumbGen(1, 30);
            flightList.add(new Flight(flightSchedule, flightNumber, numOfSeatsInTheFlight, chosenDestinations, distanceBetweenTheCities, gate.toUpperCase()));
        }
    }

    void addNewCustomerToFlight(Customer customer) {
        this.listOfRegisteredCustomersInAFlight.add(customer);
    }

    void addTicketsToExistingCustomer(Customer customer, int numOfTickets) {
        customer.addExistingFlightToCustomerList(this.customerIndex, numOfTickets);
    }

    boolean isCustomerAlreadyAdded(List<Customer> customersList, Customer customer) {
        boolean isAdded = false;
        for (Customer customer1 : customersList) {
            if (!customer1.getUserID().equals(customer.getUserID())) continue;
            isAdded = true;
            this.customerIndex = customersList.indexOf(customer1);
            break;
        }
        return isAdded;
    }

    public String calculateFlightTime(double distanceBetweenTheCities) {
        double groundSpeed = 450.0;
        double time = distanceBetweenTheCities / groundSpeed;
        String timeInString = String.format("%.4s", time);
        String[] timeArray = timeInString.replace('.', ':').split(":");
        int hours = Integer.parseInt(timeArray[0]);
        int minutes = Integer.parseInt(timeArray[1]);
        int modulus = minutes % 5;
        minutes = modulus < 3 ? (minutes -= modulus) : (minutes += 5 - modulus);
        if (minutes >= 60) {
            minutes -= 60;
            ++hours;
        }
        if (hours <= 9 && Integer.toString(minutes).length() == 1) {
            return String.format("0%s:%s0", hours, minutes);
        }
        if (hours <= 9 && Integer.toString(minutes).length() > 1) {
            return String.format("0%s:%s", hours, minutes);
        }
        if (hours > 9 && Integer.toString(minutes).length() == 1) {
            return String.format("%s:%s0", hours, minutes);
        }
        return String.format("%s:%s", hours, minutes);
    }

    public String fetchArrivalTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE, dd MMMM yyyy, HH:mm a ");
        LocalDateTime departureDateTime = LocalDateTime.parse(this.flightSchedule, formatter);
        String[] flightTime = this.getFlightTime().split(":");
        int hours = Integer.parseInt(flightTime[0]);
        int minutes = Integer.parseInt(flightTime[1]);
        LocalDateTime arrivalTime = departureDateTime.plusHours(hours).plusMinutes(minutes);
        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("EE, dd-MM-yyyy HH:mm a");
        return arrivalTime.format(formatter1);
    }

    void deleteFlight(String flightNumber) {
        boolean isFound = false;
        Iterator<Flight> list = flightList.iterator();
        while (list.hasNext()) {
            Flight flight = list.next();
            if (!flight.getFlightNumber().equalsIgnoreCase(flightNumber)) continue;
            isFound = true;
            break;
        }
        if (isFound) {
            list.remove();
        } else {
            System.out.println("Flight with given Number not found...");
        }
        this.displayFlightSchedule();
    }

    @Override
    public String[] calculateDistance(double lat1, double lon1, double lat2, double lon2) {
        double theta = lon1 - lon2;
        double distance = Math.sin(this.degreeToRadian(lat1)) * Math.sin(this.degreeToRadian(lat2)) + Math.cos(this.degreeToRadian(lat1)) * Math.cos(this.degreeToRadian(lat2)) * Math.cos(this.degreeToRadian(theta));
        distance = Math.acos(distance);
        distance = this.radianToDegree(distance);
        distance = distance * 60.0 * 1.1515;
        String[] distanceString = new String[]{String.format("%.2f", distance * 0.8684), String.format("%.2f", distance * 1.609344), Double.toString((double)Math.round(distance * 100.0) / 100.0)};
        return distanceString;
    }

    private double degreeToRadian(double deg) {
        return deg * Math.PI / 180.0;
    }

    private double radianToDegree(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public void displayFlightSchedule() {
        Iterator<Flight> flightIterator = flightList.iterator();
        System.out.println();
        System.out.print("+------+-------------------------------------------+-----------+------------------+-----------------------+------------------------+---------------------------+-------------+--------+------------------------+\n");
        System.out.printf("| Num  | FLIGHT SCHEDULE\t\t\t   | FLIGHT NO | Available Seats  | \tFROM ====>>       | \t====>> TO\t   | \t    ARRIVAL TIME       | FLIGHT TIME |  GATE  |   DISTANCE(MILES/KMS)  |%n", new Object[0]);
        System.out.print("+------+-------------------------------------------+-----------+------------------+-----------------------+------------------------+---------------------------+-------------+--------+------------------------+\n");
        int i = 0;
        while (flightIterator.hasNext()) {
            Flight f1 = flightIterator.next();
            System.out.println(f1.toString(++i));
            System.out.print("+------+-------------------------------------------+-----------+------------------+-----------------------+------------------------+---------------------------+-------------+--------+------------------------+\n");
        }
    }

    @Override
    public String toString(int i) {
        return String.format("| %-5d| %-41s | %-9s | \t%-9s | %-21s | %-22s | %-10s  |   %-6sHrs |  %-4s  |  %-8s / %-11s|", i, this.flightSchedule, this.flightNumber, this.numOfSeatsInTheFlight, this.fromWhichCity, this.toWhichCity, this.fetchArrivalTime(), this.flightTime, this.gate, this.distanceInMiles, this.distanceInKm);
    }

    public String createNewFlightsAndTime() {
        Calendar c = Calendar.getInstance();
        nextFlightDay = (int)((double)nextFlightDay + Math.random() * 7.0);
        c.add(5, nextFlightDay);
        c.add(10, nextFlightDay);
        c.set(12, c.get(12) * 3 - (int)(Math.random() * 45.0));
        Date myDateObj = c.getTime();
        LocalDateTime date = Instant.ofEpochMilli(myDateObj.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        date = this.getNearestHourQuarter(date);
        return date.format(DateTimeFormatter.ofPattern("EEEE, dd MMMM yyyy, HH:mm a "));
    }

    public LocalDateTime getNearestHourQuarter(LocalDateTime datetime) {
        int minutes = datetime.getMinute();
        int mod = minutes % 15;
        LocalDateTime newDatetime = mod < 8 ? datetime.minusMinutes(mod) : datetime.plusMinutes(15 - mod);
        newDatetime = newDatetime.truncatedTo(ChronoUnit.MINUTES);
        return newDatetime;
    }

    public int getNoOfSeats() {
        return this.numOfSeatsInTheFlight;
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setNoOfSeatsInTheFlight(int numOfSeatsInTheFlight) {
        this.numOfSeatsInTheFlight = numOfSeatsInTheFlight;
    }

    public String getFlightTime() {
        return this.flightTime;
    }

    public List<Flight> getFlightList() {
        return flightList;
    }

    public List<Customer> getListOfRegisteredCustomersInAFlight() {
        return this.listOfRegisteredCustomersInAFlight;
    }

    public String getFlightSchedule() {
        return this.flightSchedule;
    }

    public String getFromWhichCity() {
        return this.fromWhichCity;
    }

    public String getGate() {
        return this.gate;
    }

    public String getToWhichCity() {
        return this.toWhichCity;
    }
}

