# AI-Tic-Tac-Toe.java
An AI led Java program for a Tic Tac Toe game using the recursive Minimax Algorithm for game & decision making theory.

## Fetch the repo
 - Download the .zip file from [**here**](https://github.com/kxnyshk/AI-Tic-Tac-Toe.java/archive/refs/heads/master.zip)
 - Unzip/extract the dir
 - Open the extracted directory in VsCode or any other IDE of your choice.

## Run
 - Open [**`app.java`**](https://github.com/kxnyshk/AI-Tic-Tac-Toe.java/blob/master/app.java) file in your referred IDE
 - Execute it in the terminal, cmd:
 - **`java app.java`**

  ### Requirements
   - Make sure you have Java Development Kit (JDK) & Java Runtime Environment (JRE) installed and setup in your system already.
   - If not, follow [**this**](https://www.oracle.com/java/technologies/downloads/) & [**this**](https://java.com/en/download/) for JDK & JRE respectively.

## Game play
 - The User starts the game and plays first
 - User is assigned 'O', AI plays as 'X'
 - To make your move, place [1-9] at any grid box
 - Grid boxes being in a horizantal + downward order fashion
 - '1' corresponding baord[0][0], '9' being board[2][2] and others being in similar manner

## Algorithm used
 - The Algorithm used for the program is the **Minimax recursive algorithm** for game and decision making theory.

## Further reads
 - [Minimax algo | Wikipedia](https://en.wikipedia.org/wiki/Minimax)
 - [Minimax algo in Game theory (Set 1) | gfg.org](https://www.geeksforgeeks.org/minimax-algorithm-in-game-theory-set-1-introduction/)
 - [Minimax in AI | Upgrad.com](https://www.upgrad.com/blog/min-max-algorithm-in-ai/)
 - [The Minimax algo | Educative.io](https://www.educative.io/edpresso/the-minimax-algorithm)
 - [Tic Tac Toe AI with MiniMax using Python | Java Coding Community](https://www.youtube.com/watch?v=JC1QsLOXp-I)
 - [Coding Challenge 154: Tic Tac Toe AI with Minimax Algorithm | The Coding Train](https://www.youtube.com/watch?v=trKjYdBASyQ)
 - [JavaScript Tic Tac Toe Project - Unbeatable AI w/ Minimax Algorithm | freeCodeCamp.org](https://www.youtube.com/watch?v=P2TcQ3h0ipQ)
