/*
 * MIT License
 *
 * Copyright (c) 2017-2022 Ilkka Seppälä
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package array;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

import org.junit.jupiter.api.Test;

/*
 * Tests for 30 Seconds of Java code library
 *
 */
class MultiArrayConcatenationSnippetTest {
  /**
   * Tests for {@link MultiArrayConcatenationSnippet#multiArrayConcat(Object[], Object[][])}.
   */
  @Test
  void testnArrayConcat() {
    var single = MultiArrayConcatenationSnippet.multiArrayConcat(new Integer[1]);
    assertEquals(single.length, 1);
    var multiple
            = MultiArrayConcatenationSnippet.multiArrayConcat(new String[5],
                                                              new String[12],
                                                              new String[3],
                                                              new String[8]);
    assertEquals(multiple.length, 28);
    assertThrows(NullPointerException.class, () -> MultiArrayConcatenationSnippet
            .multiArrayConcat(null, null, null, null));
  }
}