## Equipment

- **One computer.** Each team is allowed use of one, and only one, computer during the competition (i.e. one computer, one keyboard). No virtual machines, etc.
- **No Internet.** You are not allowed to use the Internet to lookup/research any solutions. If you are observed using either of these during the competition, your team is subject to immediate disqualification.

## General Format

You will have 3 hours to solve as many problems as your team can. Each problem is weighted differently by difficulty, the team with the most points at the end of the three hours will win. Teams are categorized in three skill brackets: Beginner, Intermediate, and Advanced. Winners will be determined for each category. Other awards may be presented for other things like code quality and innovativeness, so look out for that.

## Rules and Guidelines

* **You will be using codescrim.com to submit your solutions.**
* **The judges' rulings are final.**
* **Your programs must be written in Java.**
* **Your problem solution must be able to produce expected results for the given input dataset.** Your program will be expected to work with judge’s dataset.
* **Follow the instructions**. Make sure you are taking input from the keyboard (`System.in`), and that your class name matches the file name.
* **You don’t have to solve all the problems.** You probably will not be able to solve them all, so you are advised to study them and choose your problems wisely.
* Each team will receive a unique team login for the competition.
* **Make sure your program outputs to the console**. No GUI stuff.
* In the case of a tie score, the winners will be determined by who solved the problem first and the fewest incorrect submissions.
* **Test before submitting**. Verify that your program works with the example input before submitting it to codescrim. Remember that every submission is tracked and will be used for tie-breakers.
* **Reference material**. Teams are allowed to bring physical reference materials and code samples to the competition, as well as use the Oracle online Java documentation.


## Problem Credits
The following people have created problems and/or contributed to the competition problems:

* **Emily Peterson** - CS Club President at Centennial High School
* **Matthew Zhang** - CS Competition Manager at Reedy High School
* **Saif Ahmad** - CS Event Manager at Reedy High School


## Java Version
```
java version "1.8.0_151"
Java(TM) SE Runtime Environment (build 1.8.0_151-b12)
Java HotSpot(TM) 64-Bit Server VM (build 25.151-b12, mixed mode)
```
