-- MySQL Script generated by MySQL Workbench
-- Mon Apr  4 09:12:05 2022
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------
-- -----------------------------------------------------
-- Schema hospital_bbdd
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema hospital_bbdd
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `hospital_bbdd` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_spanish_ci ;
USE `hospital_bbdd` ;

-- -----------------------------------------------------
-- Table `hospital_bbdd`.`usuario`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`usuario` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`usuario` (
  `DNI` VARCHAR(50) NOT NULL,
  `PASSWORD` VARCHAR(200) NOT NULL,
  `ENABLED` INT NULL DEFAULT NULL,
  `ONLINEUSU` INT NOT NULL,
  `EMAIL` VARCHAR(100) NOT NULL,
  `NOMBRE` VARCHAR(50) NULL DEFAULT NULL,
  `APELLIDO` VARCHAR(50) NULL DEFAULT NULL,
  `DIRECCION` VARCHAR(100) NULL DEFAULT NULL,
  `IMGURL` VARCHAR(200) NULL DEFAULT NULL,
  `TELEFONO` VARCHAR(10) NULL DEFAULT NULL,
  PRIMARY KEY (`DNI`),
  UNIQUE INDEX `EMAIL` (`EMAIL` ASC))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`cita`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`cita` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`cita` (
  `ID_CITA` INT NOT NULL AUTO_INCREMENT,
  `FECHA_CITA` DATE NOT NULL,
  `HORA_CITA` VARCHAR(50) NOT NULL,
  `DIRECCION_CENTROSALUD` VARCHAR(50) NOT NULL,
  `SINTOMAS` VARCHAR(30) NULL DEFAULT NULL,
  `NOMBRE_MEDICO` VARCHAR(30) NOT NULL,
  `NOMBRE_PACIENTE` VARCHAR(30) NOT NULL,
  `ESTADO` VARCHAR(30) NOT NULL,
  `DNI` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`ID_CITA`),
  INDEX `DNI` (`DNI` ASC),
  CONSTRAINT `cita_ibfk_1`
    FOREIGN KEY (`DNI`)
    REFERENCES `hospital_bbdd`.`usuario` (`DNI`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`diagnostico`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`diagnostico` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`diagnostico` (
  `ID_DIAG` INT NOT NULL AUTO_INCREMENT,
  `ALERGIAS` VARCHAR(300) NULL DEFAULT NULL,
  `TRATAMIENTO` VARCHAR(300) NULL DEFAULT NULL,
  `OPERACIONES` VARCHAR(300) NULL DEFAULT NULL,
  `ENFERMEDADES` VARCHAR(300) NULL DEFAULT NULL,
  `DNI` VARCHAR(50) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_DIAG`),
  UNIQUE INDEX `DNI` (`DNI` ASC),
  CONSTRAINT `diagnostico_ibfk_1`
    FOREIGN KEY (`DNI`)
    REFERENCES `hospital_bbdd`.`usuario` (`DNI`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`tipo`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`tipo` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`tipo` (
  `ID_TIPO` INT NOT NULL AUTO_INCREMENT,
  `DESCRIPCION` VARCHAR(300) NOT NULL,
  PRIMARY KEY (`ID_TIPO`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`medicina`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`medicina` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`medicina` (
  `COD_MED` INT NOT NULL,
  `NOMBRE_MED` VARCHAR(200) NOT NULL,
  `CANTIDAD` INT NULL DEFAULT NULL,
  `FECHA_INICIO` DATE NOT NULL,
  `FECHA_FIN` DATE NOT NULL,
  `ACTIVO` VARCHAR(2) NOT NULL,
  `ID_TIPO` INT NOT NULL,
  PRIMARY KEY (`COD_MED`),
  INDEX `ID_TIPO` (`ID_TIPO` ASC) ,
  CONSTRAINT `medicina_ibfk_1`
    FOREIGN KEY (`ID_TIPO`)
    REFERENCES `hospital_bbdd`.`tipo` (`ID_TIPO`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`historial_clinico`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`historial_clinico` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`historial_clinico` (
  `ID_HISTORIAL` INT NOT NULL AUTO_INCREMENT,
  `ID_CITA` INT NOT NULL,
  `COD_MED` INT NOT NULL,
  `DES_CITAHIS` VARCHAR(300) NULL DEFAULT NULL,
  `INSTRUCCIONES` VARCHAR(300) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_HISTORIAL`),
  INDEX `ID_CITA` (`ID_CITA` ASC) ,
  INDEX `COD_MED` (`COD_MED` ASC) ,
    FOREIGN KEY (`ID_CITA`)
    REFERENCES `hospital_bbdd`.`cita` (`ID_CITA`),
    FOREIGN KEY (`COD_MED`)
    REFERENCES `hospital_bbdd`.`medicina` (`COD_MED`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`informacion`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`informacion` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`informacion` (
  `ID_INFO` INT NOT NULL AUTO_INCREMENT,
  `PESO` INT NULL DEFAULT NULL,
  `ALTURA` VARCHAR(10) NULL DEFAULT NULL,
  `EDAD` INT NULL DEFAULT NULL,
  `SEXO` VARCHAR(10) NULL DEFAULT NULL,
  `DNI` VARCHAR(50) NULL DEFAULT NULL,
  PRIMARY KEY (`ID_INFO`),
  UNIQUE INDEX `DNI` (`DNI` ASC) ,
  CONSTRAINT `informacion_ibfk_1`
    FOREIGN KEY (`DNI`)
    REFERENCES `hospital_bbdd`.`usuario` (`DNI`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`perfil`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`perfil` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`perfil` (
  `ID_PERFIL` INT NOT NULL AUTO_INCREMENT,
  `DESC_PER` VARCHAR(20) NOT NULL,
  PRIMARY KEY (`ID_PERFIL`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`usuario_perfil`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`usuario_perfil` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`usuario_perfil` (
  `DNI` VARCHAR(50) NOT NULL,
  `ID_PERFIL` INT NOT NULL,
  PRIMARY KEY (`DNI`, `ID_PERFIL`),
  INDEX `ID_PERFIL` (`ID_PERFIL` ASC) ,
  CONSTRAINT `usuario_perfil_ibfk_1`
    FOREIGN KEY (`DNI`)
    REFERENCES `hospital_bbdd`.`usuario` (`DNI`),
  CONSTRAINT `usuario_perfil_ibfk_2`
    FOREIGN KEY (`ID_PERFIL`)
    REFERENCES `hospital_bbdd`.`perfil` (`ID_PERFIL`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;


-- -----------------------------------------------------
-- Table `hospital_bbdd`.`comentarios`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hospital_bbdd`.`comentarios` ;

CREATE TABLE IF NOT EXISTS `hospital_bbdd`.`comentarios` (
  `ID_COM` INT NOT NULL AUTO_INCREMENT,
  `DNI_1` VARCHAR(50) NOT NULL,
  `DNI_2` VARCHAR(50) NOT NULL,
  `COMENTARIO` VARCHAR(100) NULL,
 PRIMARY KEY (`ID_COM`)
  )
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_spanish_ci;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;


INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('71706550w', '1234', '1', '1', 'rodrigo@email.com', 'rodrigo', 'sendino', 'glorieta', 'url(1)', '627787302');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('6574848e', '1234', '1', '1', 'epepe@gmoalm,', 'pepe', 'pepe', 'manue', 'manue', '627787324');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('503942f', '124', '1', '0', 'jaunsd@rfkwer', 'juan', 'juan', 'juan', 'juan', '34728291');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('34728920w', 'wdn23', '1', '1', 'jauma@sdm.cp,', 'jaume', 'juame', 'jaume', 'juame', '29372293');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('483920m', 'maria123', '1', '1', 'maria@meail.com', 'maria', 'maria', 'maria', 'maria()', '54372293');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('med123', 'med123', '1', '1', 'medico@mail.com', 'medico', 'medico', 'medico', 'medico', '673782812');
INSERT INTO `hospital_bbdd`.`usuario` (`DNI`, `PASSWORD`, `ENABLED`, `ONLINEUSU`, `EMAIL`, `NOMBRE`, `APELLIDO`, `DIRECCION`, `IMGURL`, `TELEFONO`) VALUES ('123', '123', '123', '123', '123@mail.com', '123', '123', '123', '123', '123123123');

INSERT INTO `hospital_bbdd`.`informacion` (`PESO`, `ALTURA`, `EDAD`, `SEXO`, `DNI`) VALUES ('23', '1,23', '23', 'm', '34728920w');
INSERT INTO `hospital_bbdd`.`informacion` (`PESO`, `ALTURA`, `EDAD`, `SEXO`, `DNI`) VALUES ('34', '1,45', '32', 'f', '483920m');
INSERT INTO `hospital_bbdd`.`informacion` (`PESO`, `ALTURA`, `EDAD`, `SEXO`, `DNI`) VALUES ('70', '1,80', '45', 'm', '503942f');
INSERT INTO `hospital_bbdd`.`informacion` (`PESO`, `ALTURA`, `EDAD`, `SEXO`, `DNI`) VALUES ('65', '1,70', '32', 'm', '6574848e');
INSERT INTO `hospital_bbdd`.`informacion` (`PESO`, `ALTURA`, `EDAD`, `SEXO`, `DNI`) VALUES ('68', '1,78', '25', 'm', '71706550w');



INSERT INTO `hospital_bbdd`.`diagnostico` (`ALERGIAS`, `ENFERMEDADES`, `DNI`) VALUES ('polen, cereales', 'COVID', '34728920w');
INSERT INTO `hospital_bbdd`.`diagnostico` (`ALERGIAS`, `OPERACIONES`, `DNI`) VALUES ('cereales', 'operacion de rodilla', '483920m');
INSERT INTO `hospital_bbdd`.`diagnostico` (`ALERGIAS`, `TRATAMIENTO`, `ENFERMEDADES`, `DNI`) VALUES ('graminias', 'colirio', 'lyme', '503942f');
INSERT INTO `hospital_bbdd`.`diagnostico` (`ALERGIAS`, `ENFERMEDADES`, `DNI`) VALUES ('frutos secos', 'VIH', '6574848e');
INSERT INTO `hospital_bbdd`.`diagnostico` (`ALERGIAS`, `TRATAMIENTO`, `OPERACIONES`, `DNI`) VALUES ('graminias', 'colirio', 'coartacion de aorta', '71706550w');

INSERT INTO `hospital_bbdd`.`perfil` (`ID_PERFIL`, `DESC_PER`) VALUES ('1', 'Paciente');
INSERT INTO `hospital_bbdd`.`perfil` (`ID_PERFIL`, `DESC_PER`) VALUES ('2', 'Medico');


INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('med123', '2');
INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('71706550w', '1');
INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('34728920w', '1');
INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('483920m', '1');
INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('503942f', '1');
INSERT INTO `hospital_bbdd`.`usuario_perfil` (`DNI`, `ID_PERFIL`) VALUES ('6574848e', '1');


INSERT INTO `hospital_bbdd`.`tipo` (`ID_TIPO`, `DESCRIPCION`) VALUES ('1', 'ANALGESICO');
INSERT INTO `hospital_bbdd`.`tipo` (`ID_TIPO`, `DESCRIPCION`) VALUES ('2', 'ANTIFLAMATORIO');
INSERT INTO `hospital_bbdd`.`tipo` (`ID_TIPO`, `DESCRIPCION`) VALUES ('3', 'ANTIPIRUETICOS');


INSERT INTO `hospital_bbdd`.`medicina` (`COD_MED`, `NOMBRE_MED`, `CANTIDAD`, `FECHA_INICIO`,`FECHA_FIN`,`ACTIVO`,`ID_TIPO`) VALUES ('1234', 'DALSY', '12', '2022-06-12','2023-04-12','SI','1');
INSERT INTO `hospital_bbdd`.`medicina` (`COD_MED`, `NOMBRE_MED`, `CANTIDAD`, `FECHA_INICIO`,`FECHA_FIN`,`ACTIVO`,`ID_TIPO`) VALUES ('4321', 'IBUPORFENO','12','2024-06-23','2025-04-12','SI','2');
INSERT INTO `hospital_bbdd`.`medicina` (`COD_MED`, `NOMBRE_MED`, `CANTIDAD`, `FECHA_INICIO`,`FECHA_FIN`,`ACTIVO`,`ID_TIPO`) VALUES ('2342', 'NOLOTIL','13','2027-06-23','2022-10-12','NO','3');

INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`,`HORA_CITA`,`DIRECCION_CENTROSALUD`,`SINTOMAS`,`NOMBRE_MEDICO`,`NOMBRE_PACIENTE`,`ESTADO`,`DNI`) VALUES ('2022-04-28','08:20','Direcion rontonda 2','Dedos rotos','med123','rodrigo','Realizado','71706550w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`,`HORA_CITA`,`DIRECCION_CENTROSALUD`,`SINTOMAS`,`NOMBRE_MEDICO`,`NOMBRE_PACIENTE`,`ESTADO`,`DNI`) VALUES ('2022-06-12','10:30','Direccion1',NULL,'med123','rodrigo','Pendiente','71706550w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`,`HORA_CITA`,`DIRECCION_CENTROSALUD`,`SINTOMAS`,`NOMBRE_MEDICO`,`NOMBRE_PACIENTE`,`ESTADO`,`DNI`) VALUES ('2022-04-23','11:45','Direcion rontonda 1','Congestion','med123','jaume','Pendiente','34728920w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`, `DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-04-28','08:20', 'Direcion rontonda 2', 'Dedos rotos', 'med123', 'rodrigo', 'Realizada', '71706550w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`, `DIRECCION_CENTROSALUD`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-06-12','10:30', 'Direccion1', 'med123', 'rodrigo', 'Pendiente', '71706550w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-04-23','11:45', 'Direcion rontonda 1', 'Congestion', 'med123', 'jaume', 'Pendiente', '34728920w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`,`HORA_CITA`,`DIRECCION_CENTROSALUD`,`SINTOMAS`,`NOMBRE_MEDICO`,`NOMBRE_PACIENTE`,`ESTADO`,`DNI`) VALUES ('2022-04-28','08:20','Direcion rontonda 2','Dedos rotos','med123','rodrigo','Realizado','71706550w');

INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-06-12','10:30', 'Direccion1', NULL, 'med123', 'rodrigo', 'Pendiente', '71706550w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-04-23','11:45', 'Direcion rontonda 1', 'Congestion', 'med123', 'jaume', 'Pendiente', '34728920w');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-05-12','12:00', 'Dire 1', 'Gripe', 'med123', '123', 'Pendiente', '123');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-06-11','12:00', 'Dire 1', 'Congestion', 'med123', '123', 'Cancelado', '123');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-04-12','11:00', 'Dire 2', 'Herida', 'med123', '123', 'Realizado', '123');
INSERT INTO `hospital_bbdd`.`cita` (`FECHA_CITA`, `HORA_CITA`,`DIRECCION_CENTROSALUD`, `SINTOMAS`, `NOMBRE_MEDICO`, `NOMBRE_PACIENTE`, `ESTADO`, `DNI`) VALUES ('2022-05-10','12:00', 'calle 1º 3d', 'Dolor de cabeza', 'med123', '123', 'Enprogreso', '123');


INSERT INTO `hospital_bbdd`.`historial_clinico` (`ID_CITA`, `COD_MED`, `DES_CITAHIS`, `INSTRUCCIONES`) VALUES ('1', '1234', 'AFECCION MEDIA', 'TOMAR CADA 2 H');
INSERT INTO `hospital_bbdd`.`historial_clinico` (`ID_CITA`, `COD_MED`, `DES_CITAHIS`, `INSTRUCCIONES`) VALUES ('2', '4321', 'AFECION LEVE', 'TOMAR CADA 8H');
INSERT INTO `hospital_bbdd`.`historial_clinico` (`ID_CITA`, `COD_MED`, `DES_CITAHIS`, `INSTRUCCIONES`) VALUES ('3', '2342', 'AFECCION GRAVE', 'TOMAR CADA 6H');

INSERT INTO `hospital_bbdd`.`comentarios` (`DNI_1`, `DNI_2`, `COMENTARIO`) VALUES ('34728920w', '503942f', 'Hola esto es una prueba');
INSERT INTO `hospital_bbdd`.`comentarios` (`DNI_1`, `DNI_2`, `COMENTARIO`) VALUES ('med123', '34728920w', 'Prueba 2');


SELECT * FROM hospital_bbdd.diagnostico WHERE DNI = '503942f';

SELECT * FROM hospital_bbdd.informacion WHERE DNI = '503942f';

SELECT * FROM hospital_bbdd.comentarios WHERE DNI_1 = '34728920w' OR DNI_2 = '34728920w' ;

SELECT * FROM hospital_bbdd.cita where NOMBRE_MEDICO like '%2022-04%' OR NOMBRE_PACIENTE like '%2022-04%' OR fecha_cita like '%2022-04%' OR HORA_CITA like '%2022-04%';

SELECT * FROM hospital_bbdd.medicina where activo = "NO";


SELECT *
FROM
    hospital_bbdd.medicina
WHERE
   COD_MED
    IN
   (
    SELECT
  COD_MED
   FROM
     hospital_bbdd.historial_clinico
   WHERE
    ID_CITA
    IN
    (
    SELECT
    ID_CITA
     FROM
     hospital_bbdd.cita
     WHERE
    DNI ='71706550w'
    )
) AND ACTIVO ='SI';



SELECT *
FROM
    hospital_bbdd.historial_clinico
WHERE
   ID_CITA
    IN
   (
    SELECT
  ID_CITA
   FROM
     hospital_bbdd.cita
   WHERE
    DNI ='71706550w'
);

SELECT *
FROM hospital_bbdd.medicina
LEFT JOIN tipo
ON medicina.ID_TIPO = tipo.ID_TIPO;

CREATE USER 'umedico'@'localhost' IDENTIFIED BY 'umedico';
GRANT ALL PRIVILEGES ON HOSPITAL_BBDD.* TO  'umedico'@'localhost';
